package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class BackServiceService {

	private static BackServiceServiceAuthenticator authenticator;

	public static AlexandriaSpark setup(AlexandriaSpark server, UnitBox box) {
		authenticator = new BackServiceServiceAuthenticator(box);
		server.route("/servlet/backservice").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostBackServiceDispatcherResource(box, manager).execute());
		server.route("/backservice/adddatastorecubefact").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddDatastoreCubeFactResource(box, manager).execute());
		server.route("/backservice/adddatastorecubefacts").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddDatastoreCubeFactsResource(box, manager).execute());
		server.route("/backservice/adddatastoredimensioncomponent").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddDatastoreDimensionComponentResource(box, manager).execute());
		server.route("/backservice/addnodeflag").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddNodeFlagResource(box, manager).execute());
		server.route("/backservice/addnodenote").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddNodeNoteResource(box, manager).execute());
		server.route("/backservice/addsourceterm").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddSourceTermResource(box, manager).execute());
		server.route("/backservice/addtaskflact").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddTaskFactResource(box, manager).execute());
		server.route("/backservice/addtaskflag").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddTaskFlagResource(box, manager).execute());
		server.route("/backservice/addtaskshortcut").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostAddTaskShortcutResource(box, manager).execute());
		server.route("/backservice/consolidatenode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostConsolidateNodeResource(box, manager).execute());
		server.route("/backservice/createaccount").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostCreateAccountResource(box, manager).execute());
		server.route("/backservice/createnode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostCreateNodeResource(box, manager).execute());
		server.route("/backservice/createtask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostCreateTaskResource(box, manager).execute());
		server.route("/backservice/deletenodeflag").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostDeleteNodeFlagResource(box, manager).execute());
		server.route("/backservice/deletenodenote").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostDeleteNodeNoteResource(box, manager).execute());
		server.route("/backservice/createtaskflag").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostDeleteTaskFlagResource(box, manager).execute());
		server.route("/backservice/deletetaskshortcut").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostDeleteTaskShortcutResource(box, manager).execute());
		server.route("/backservice/downloaddistribution").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostDownloadDistributionResource(box, manager).execute());
		server.route("/backservice/emptytrash").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostEmptyTrashResource(box, manager).execute());
		server.route("/backservice/executeexporter").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostExecuteExporterResource(box, manager).execute());
		server.route("/backservice/executenodecommand").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostExecuteNodeCommandResource(box, manager).execute());
		server.route("/backservice/existsnode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostExistsNodeResource(box, manager).execute());
		server.route("/backservice/exportnode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostExportNodeResource(box, manager).execute());
		server.route("/backservice/exportnodes").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostExportNodesResource(box, manager).execute());
		server.route("/backservice/getnodeancestors").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeAncestorsResource(box, manager).execute());
		server.route("/backservice/getnodedocument").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeDocumentResource(box, manager).execute());
		server.route("/backservice/getnodedocumentcontenttype").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeDocumentContentTypeResource(box, manager).execute());
		server.route("/backservice/getnodefile").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeFileResource(box, manager).execute());
		server.route("/backservice/getnodeflags").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeFlagsResource(box, manager).execute());
		server.route("/backservice/getnodelocation").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeLocationResource(box, manager).execute());
		server.route("/backservice/getnodenotes").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeNotesResource(box, manager).execute());
		server.route("/backservice/getnodereference").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeReferenceResource(box, manager).execute());
		server.route("/backservice/getnodereferences").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeReferencesResource(box, manager).execute());
		server.route("/backservice/getnodereferencescount").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeReferencesCountResource(box, manager).execute());
		server.route("/backservice/getnodeschema").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeSchemaResource(box, manager).execute());
		server.route("/backservice/getnodetasks").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetNodeTasksResource(box, manager).execute());
		server.route("/backservice/getsourceparentterm").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetSourceParentTermResource(box, manager).execute());
		server.route("/backservice/getsourceterms").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetSourceTermsResource(box, manager).execute());
		server.route("/backservice/gettaskfacts").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetTaskFactsResource(box, manager).execute());
		server.route("/backservice/gettaskflags").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetTaskFlagsResource(box, manager).execute());
		server.route("/backservice/gettaskprocess").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetTaskProcessResource(box, manager).execute());
		server.route("/backservice/gettasks").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetTasksResource(box, manager).execute());
		server.route("/backservice/gettaskshortcuts").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetTaskShortcutsResource(box, manager).execute());
		server.route("/backservice/getuserlinkedtonode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetUserLinkedToNodeResource(box, manager).execute());
		server.route("/backservice/getusernode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetUserNodeResource(box, manager).execute());
		server.route("/backservice/getusertasks").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetUserTasksResource(box, manager).execute());
		server.route("/backservice/gotoplaceintask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGotoPlaceInTaskResource(box, manager).execute());
		server.route("/backservice/haspermissions").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostHasPermissionsResource(box, manager).execute());
		server.route("/backservice/importnode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostImportNodeResource(box, manager).execute());
		server.route("/backservice/loadsource").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostLoadSourceResource(box, manager).execute());
		server.route("/backservice/loaduser").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostLoadUserResource(box, manager).execute());
		server.route("/backservice/locatenode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostLocateNodeResource(box, manager).execute());
		server.route("/backservice/locatesource").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostLocateSourceResource(box, manager).execute());
		server.route("/backservice/makenodedeleteable").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMakeNodeDeletableResource(box, manager).execute());
		server.route("/backservice/makenodeeditable").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMakeNodeEditableResource(box, manager).execute());
		server.route("/backservice/makenodeprivate").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMakeNodePrivateResource(box, manager).execute());
		server.route("/backservice/makenodepublic").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMakeNodePublicResource(box, manager).execute());
		server.route("/backservice/makenodeundeleteable").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMakeNodeUndeletableResource(box, manager).execute());
		server.route("/backservice/makenodeuneditable").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMakeNodeUneditableResource(box, manager).execute());
		server.route("/backservice/opendatastore").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostOpenDatastoreResource(box, manager).execute());
		server.route("/backservice/opennode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostOpenNodeResource(box, manager).execute());
		server.route("/backservice/opentask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostOpenTaskResource(box, manager).execute());
		server.route("/backservice/recovernode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostRecoverNodeResource(box, manager).execute());
		server.route("/backservice/removenode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostRemoveNodeResource(box, manager).execute());
		server.route("/backservice/removetask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostRemoveTaskResource(box, manager).execute());
		server.route("/backservice/resetnodeform").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostResetNodeFormResource(box, manager).execute());
		server.route("/backservice/resumetask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostResumeTaskResource(box, manager).execute());
		server.route("/backservice/runtask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostRunTaskResource(box, manager).execute());
		server.route("/backservice/savenode").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodeResource(box, manager).execute());
		server.route("/backservice/savenodedocument").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodeDocumentResource(box, manager).execute());
		server.route("/backservice/savenodefile").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodeFileResource(box, manager).execute());
		server.route("/backservice/savenodeparent").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodeParentResource(box, manager).execute());
		server.route("/backservice/savenodepartnercontext").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodePartnerContextResource(box, manager).execute());
		server.route("/backservice/savenodepicture").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodePictureResource(box, manager).execute());
		server.route("/backservice/savenodereference").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodeReferenceResource(box, manager).execute());
		server.route("/backservice/savenodesattribute").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveNodesAttributeResource(box, manager).execute());
		server.route("/backservice/savetask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveTaskResource(box, manager).execute());
		server.route("/backservice/saveuser").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSaveUserResource(box, manager).execute());
		server.route("/backservice/searchevent").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSearchEventResource(box, manager).execute());
		server.route("/backservice/searchnodes").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSearchNodesResource(box, manager).execute());
		server.route("/backservice/api").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostApiResource(box, manager).execute());
		server.route("/backservice/subscribe").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSubscribeResource(box, manager).execute());
		server.route("/backservice/unlocktask").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostUnlockTaskResource(box, manager).execute());

		return server;
	}
}