package io.intino.goros.unit.printers.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class PdfTaskListTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((type("tasklist"))).output(literal("<?xml version='1.0' encoding='UTF-8'?>\n<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n\n  <fo:layout-master-set>\n    <fo:simple-page-master master-name=\"cover\" page-height=\"29.7cm\" page-width=\"21cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n      <fo:region-body margin-top=\"10cm\" />\n    </fo:simple-page-master>\n\n    <fo:simple-page-master master-name=\"page-portrait\" page-height=\"29.7cm\" page-width=\"21cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n      <fo:region-body margin-top=\"1cm\" margin-bottom=\"1cm\"/>\n      <fo:region-before precedence=\"true\" extent=\"1cm\"/>\n      <fo:region-after precedence=\"true\" extent=\"0.5cm\"/>\n      <fo:region-start extent=\"1cm\"/>\n      <fo:region-end extent=\"1cm\"/>\n    </fo:simple-page-master>\n\n    <fo:simple-page-master master-name=\"page-landscape\" page-height=\"21cm\" page-width=\"29.7cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"1cm\" margin-right=\"1cm\">\n      <fo:region-body margin-top=\"1cm\" margin-bottom=\"1cm\"/>\n      <fo:region-before precedence=\"true\" extent=\"1cm\"/>\n      <fo:region-after precedence=\"true\" extent=\"0.5cm\"/>\n      <fo:region-start extent=\"1cm\"/>\n      <fo:region-end extent=\"1cm\"/>\n    </fo:simple-page-master>\n\n    <fo:simple-page-master master-name=\"section\" page-height=\"29.7cm\" page-width=\"21cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n      <fo:region-body margin-top=\"10cm\" />\n    </fo:simple-page-master>\n  </fo:layout-master-set>\n\n  <fo:page-sequence master-reference=\"page-")).output(mark("orientation")).output(literal("\">\n    <fo:static-content flow-name=\"xsl-region-before\">\n      <fo:block text-align=\"end\" font-size=\"10pt\" font-family=\"serif\" line-height=\"14pt\" color=\"#555\"></fo:block>\n    </fo:static-content>\n\n    <fo:static-content flow-name=\"xsl-region-after\">\n      <fo:block text-align=\"end\" font-size=\"10pt\" font-family=\"serif\" line-height=\"14pt\" color=\"#555\" border-top=\"0.5pt solid #555\">")).output(mark("label")).output(literal(" - ")).output(mark("pageLabel")).output(literal(" <fo:page-number/></fo:block>\n    </fo:static-content>\n\n    <fo:static-content flow-name=\"xsl-region-start\">\n      <fo:block-container height=\"22.2cm\" width=\"1cm\" top=\"0cm\" left=\"0cm\" position=\"absolute\">\n        <fo:block text-align=\"start\"></fo:block>\n      </fo:block-container>\n    </fo:static-content>\n\n    <fo:static-content flow-name=\"xsl-region-end\">\n      <fo:block-container height=\"22.2cm\" width=\"1cm\" top=\"0cm\" left=\"0cm\" position=\"absolute\">\n        <fo:block text-align=\"start\"></fo:block>\n      </fo:block-container>\n    </fo:static-content>\n\n    <fo:flow flow-name=\"xsl-region-body\">")).output(mark("content")).output(literal("</fo:flow>\n\n  </fo:page-sequence>\n</fo:root>")),
			rule().condition((allTypes("content","empty"))).output(literal("<fo:block font-size=\"20pt\" margin-bottom=\"5mm\" >")).output(mark("label")).output(literal("</fo:block>\n<fo:block font-size=\"10pt\" margin-bottom=\"6mm\" color=\"#666666\">")).output(mark("date")).output(literal("</fo:block>\n<fo:block>")).output(mark("noElementsMessage")).output(literal("</fo:block>")),
			rule().condition((type("content"))).output(literal("<fo:block font-size=\"20pt\" margin-bottom=\"5mm\" >")).output(mark("label")).output(literal("</fo:block>\n<fo:block font-size=\"10pt\" margin-bottom=\"6mm\" color=\"#666666\">")).output(mark("date")).output(literal("</fo:block>\n<fo:table table-layout=\"fixed\">\n    ")).output(mark("header", "columns")).output(literal("\n    <fo:table-header>")).output(mark("header")).output(literal("</fo:table-header>\n    <fo:table-body>")).output(mark("references")).output(literal("</fo:table-body>\n</fo:table>")),
			rule().condition((type("header")), (trigger("columns"))).output(expression().output(mark("reference", "column").multiple("\n"))),
			rule().condition((type("header"))).output(expression().output(mark("reference", "header").multiple("\n"))),
			rule().condition((type("references"))).output(expression().output(mark("reference").multiple("\n"))),
			rule().condition((type("reference")), (trigger("column"))).output(expression().output(mark("attribute", "column").multiple("\n"))).output(literal("\n<fo:table-column column-width=\"")).output(mark("width")).output(literal("%\"/>")),
			rule().condition((type("reference")), (trigger("header"))).output(literal("<fo:table-row background-color=\"#EFF7FF\" margin-bottom=\"2mm\" border-top=\"0.2mm solid #5E93B1\" border-bottom=\"0.1mm solid #5E93B1\">\n    ")).output(expression().output(mark("attribute", "header").multiple("\n"))).output(literal("\n</fo:table-row>")),
			rule().condition((type("reference"))).output(literal("<fo:table-row")).output(expression().output(literal(" background-color=\"#ddd\"")).output(mark("odd", "empty"))).output(literal(">\n    ")).output(expression().output(mark("attribute").multiple("\n"))).output(literal("\n</fo:table-row>")),
			rule().condition((type("attribute")), (trigger("column"))).output(literal("<fo:table-column column-width=\"")).output(mark("width")).output(literal("%\"/>")),
			rule().condition((type("attribute")), (trigger("header"))).output(literal("<fo:table-cell padding-left=\"0.5mm\" padding-top=\"2mm\" padding-bottom=\"2mm\" wrap-option=\"wrap\">\n    <fo:block font-size=\"10pt\" font-weight=\"bold\">")).output(mark("label")).output(literal("</fo:block>\n</fo:table-cell>")),
			rule().condition((type("attribute"))).output(literal("<fo:table-cell padding-left=\"0.5mm\" font-size=\"8pt\" padding-top=\"2mm\" padding-bottom=\"2mm\"><fo:block>")).output(mark("value")).output(literal("</fo:block></fo:table-cell>")),
			rule().condition((type("odd")), (trigger("empty")))
		);
	}
}