/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.spark.UIFile;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskFolderGrouping;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskNatureGrouping;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskUrgentGrouping;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskDownloadDialog;
import io.intino.goros.unit.box.ui.displays.templates.DownloadDialogOption;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import io.intino.goros.unit.util.TaskHelper;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.monet.space.kernel.model.TaskFilters;
import org.monet.space.kernel.model.TaskSearchRequest;
import org.monet.space.kernel.model.TaskType;

public class TaskDownloadDialog
extends AbstractTaskDownloadDialog<UnitBox> {
    private String inbox;
    private Consumer<Boolean> terminateListener;
    private String condition;
    private List<Filter> filters;
    private String sorting;
    private String sortingMode;
    private List<Column> columns = new ArrayList<Column>();

    public TaskDownloadDialog(UnitBox box) {
        super(box);
    }

    public TaskDownloadDialog onTerminate(Consumer<Boolean> listener) {
        this.terminateListener = listener;
        return this;
    }

    public TaskDownloadDialog inbox(String inbox) {
        this.inbox = inbox;
        return this;
    }

    public TaskDownloadDialog condition(String condition) {
        this.condition = condition;
        return this;
    }

    public TaskDownloadDialog filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public TaskDownloadDialog sorting(String sorting, String mode) {
        this.sorting = sorting;
        this.sortingMode = mode;
        return this;
    }

    public TaskDownloadDialog columns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.format.onSelect(e -> this.refreshToolbar());
        this.downloadCancel.onExecute(e -> this.terminateListener.accept(true));
        this.downloadAccept.onExecute(e -> this.accept());
        this.columnModeSelector.onSelect(e -> this.updateMode());
    }

    public void refresh() {
        super.refresh();
        this.format.select(new String[]{"pdf"});
        this.columnModeSelector.select("allColumns");
        this.refreshColumns();
        this.refreshToolbar();
    }

    private boolean check() {
        if (this.format.selection().size() <= 0) {
            return false;
        }
        if (this.allColumnsMode()) {
            return true;
        }
        return this.options.children(DownloadDialogOption.class).stream().anyMatch(c -> c.selectedColumn() != null);
    }

    private UIFile accept() {
        this.terminateListener.accept(true);
        this.notifyUser(this.translate("Downloading data..."), UserMessage.Type.Info);
        final String format = (String)this.format.selection().get(0);
        List<String> selection = this.selectedColumns();
        final InputStream result = TaskHelper.download((UnitBox)this.box(), this.request(), format, this.language(), selection, this.session());
        this.notifyUser(this.translate("Download finished"), UserMessage.Type.Success);
        return new UIFile(){

            public String label() {
                return "Tareas_" + Formatters.downloadDate(Instant.now()) + "." + format.toLowerCase();
            }

            public InputStream content() {
                return result;
            }
        };
    }

    private TaskSearchRequest request() {
        TaskSearchRequest request = new TaskSearchRequest();
        request.setCondition(this.condition);
        request.addParameter("type", this.taskType());
        request.addParameter("state", this.filterValue("state"));
        request.addParameter("box", this.inbox);
        request.addParameter("situation", this.folder());
        request.addParameter("background", this.filterValue("nature") != null ? "" + TaskNatureGrouping.from(this.filterValue("nature")).value() : null);
        request.addParameter("role", this.filterValue("role"));
        request.addParameter("urgent", this.filterValue("urgent") != null ? "" + TaskUrgentGrouping.Urgent.value() : null);
        request.addParameter("owner", this.filterValue("owner"));
        if (this.sorting != null) {
            request.setSortsBy(NodeHelper.sortsByOf(Collections.singletonList(NodeHelper.sortingOf(this.sorting, this.sortingMode))));
        }
        if (request.getParameter("situation") == null) {
            request.addParameter("situation", TaskFolderGrouping.Active.name().toLowerCase());
        }
        request.setStartPos(Integer.valueOf(0));
        request.setLimit(Integer.valueOf(-1));
        return request;
    }

    private String folder() {
        String folder = this.filterValue("folder");
        TaskFolderGrouping grouping = folder != null ? TaskFolderGrouping.from(folder) : TaskFolderGrouping.Active;
        return grouping.name().toLowerCase();
    }

    private String taskType() {
        String type = this.filterValue("type");
        if (type == null) {
            return null;
        }
        TaskFilters taskFilters = LayerHelper.taskLayer().loadTasksFilters(this.language());
        TaskType taskType = taskFilters.types.stream().filter(t -> t.getLabel().equals(type)).findFirst().orElse(null);
        return taskType != null ? taskType.getCode() : null;
    }

    private String filterValue(String name) {
        Filter filter = this.filters.stream().filter(f -> f.grouping().equals(name)).findFirst().orElse(null);
        return filter != null ? this.firstGroup(filter) : null;
    }

    private String firstGroup(Filter filter) {
        GroupFilter groupFilter = (GroupFilter)filter;
        return groupFilter.groups().size() > 0 ? (String)groupFilter.groups().iterator().next() : null;
    }

    private List<String> selectedColumns() {
        if (this.allColumnsMode()) {
            return this.columns.stream().map(Column::code).collect(Collectors.toList());
        }
        List children = this.options.children(DownloadDialogOption.class);
        return children.stream().map(DownloadDialogOption::selectedColumn).filter(Objects::nonNull).map(Column::code).collect(Collectors.toList());
    }

    private List<Column> availableColumns(Column current) {
        List<String> selection = this.selectedColumns();
        return this.columns.stream().filter(c -> current != null && current.code().equals(c.code()) || !selection.contains(c.code())).collect(Collectors.toList());
    }

    private void refreshAvailableColumns() {
        List children = this.options.children(DownloadDialogOption.class);
        children.forEach(c -> c.columns(this.availableColumns(c.selectedColumn())).refresh());
    }

    private void refreshColumns() {
        this.customColumnsBlock.visible(!this.allColumnsMode());
        this.columnsBlock.hide();
        this.options.clear();
        for (int i = 0; i < this.columns.size(); ++i) {
            this.fill(i, (DownloadDialogOption)this.options.add());
        }
        this.columnsBlock.show();
    }

    private void fill(int pos, DownloadDialogOption view) {
        view.index(pos);
        view.columns(this.columns);
        view.onSelect(e -> {
            this.refreshToolbar();
            this.refreshAvailableColumns();
        });
        view.refresh();
    }

    private void refreshToolbar() {
        this.downloadAccept.readonly(!this.check());
    }

    private boolean allColumnsMode() {
        String mode = this.columnModeSelector.selection().size() > 0 ? (String)this.columnModeSelector.selection().get(0) : null;
        return mode == null || mode.equalsIgnoreCase("allColumns");
    }

    private void updateMode() {
        this.customColumnsBlock.visible(!this.allColumnsMode());
        this.refreshToolbar();
    }
}

