/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractRolesFiltersTemplate;

public class RolesFiltersTemplate
extends AbstractRolesFiltersTemplate<UnitBox> {
    private Collection collection;

    public RolesFiltersTemplate(UnitBox box) {
        super(box);
    }

    public RolesFiltersTemplate bindTo(Collection collection) {
        this.collection = collection;
        this.updateFilters();
        this.expired.checked(true);
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.reset.onExecute(e -> this.resetFilters());
    }

    private void resetFilters() {
        this.definition.clearSelection();
        this.type.clearSelection();
        this.nature.clearSelection();
        this.expired.clearSelection();
        this.collection.clearFilters();
    }

    private void updateFilters() {
        this.updateDefinition();
        this.udpateType();
        this.udpateNature();
        this.udpateExpired();
    }

    private void updateDefinition() {
        this.definition.label(this.translate("Class"));
        this.definition.attribute("definition");
        this.definition.bindTo(this.collection);
        this.definition.multipleSelection(false);
        this.definition.refresh();
    }

    private void udpateType() {
        this.type.label(this.translate("Type"));
        this.type.attribute("type");
        this.type.bindTo(this.collection);
        this.type.multipleSelection(false);
        this.type.refresh();
    }

    private void udpateNature() {
        this.nature.label(this.translate("Nature"));
        this.nature.attribute("nature");
        this.nature.bindTo(this.collection);
        this.nature.multipleSelection(false);
        this.nature.refresh();
    }

    private void udpateExpired() {
        this.expired.label(this.translate("Non expired"));
        this.expired.attribute("expired");
        this.expired.bindTo(this.collection);
        this.expired.refresh();
    }
}

