/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractPublishTermsDialog;
import io.intino.goros.unit.util.LayerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.monet.metamodel.SourceDefinition;
import org.monet.space.kernel.model.Source;
import org.monet.space.kernel.model.Term;

public class PublishTermsDialog
extends AbstractPublishTermsDialog<UnitBox> {
    private Source<SourceDefinition> source;
    private Consumer<Boolean> publishListener;
    private Consumer<Boolean> deleteListener;

    public PublishTermsDialog(UnitBox box) {
        super(box);
    }

    public PublishTermsDialog source(Source<SourceDefinition> source) {
        this.source = source;
        return this;
    }

    public PublishTermsDialog onPublish(Consumer<Boolean> listener) {
        this.publishListener = listener;
        return this;
    }

    public PublishTermsDialog onDelete(Consumer<Boolean> listener) {
        this.deleteListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.publish.onExecute(e -> this.publish(this.newTerms.selection()));
        this.delete.onExecute(e -> this.delete(this.newTerms.selection()));
        this.publishAll.onExecute(e -> this.publishAll());
        this.newTerms.onSelect(e -> this.refresh());
    }

    public void refresh() {
        super.refresh();
        ArrayList<Term> terms = this.loadNewTerms();
        this.newTerms.clear();
        terms.forEach(t -> this.newTerms.add(t.getCode()));
        this.publish.readonly(this.newTerms.selection().size() <= 0);
        this.delete.readonly(this.newTerms.selection().size() <= 0);
        this.publishAll.readonly(terms.size() <= 0);
    }

    private ArrayList<Term> loadNewTerms() {
        return new ArrayList<Term>(LayerHelper.sourceLayer().loadSourceNewTerms(this.source).get().values());
    }

    private void publish(List<String> selection) {
        LayerHelper.sourceLayer().publishSourceTerms(this.source, selection.toArray(new String[0]));
        this.notifyUser(this.translate("Terms published"), UserMessage.Type.Success);
        this.publishListener.accept(true);
        this.refresh();
    }

    private void delete(List<String> selection) {
        selection.forEach(s -> LayerHelper.sourceLayer().deleteSourceTerm(this.source, s));
        this.notifyUser(this.translate("Terms deleted"), UserMessage.Type.Success);
        this.deleteListener.accept(true);
        this.refresh();
    }

    private void publishAll() {
        this.publish(this.loadNewTerms().stream().map(Term::getCode).collect(Collectors.toList()));
    }
}

