/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.box.ui.displays.templates.AbstractDownloadDialogOption;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DownloadDialogOption
extends AbstractDownloadDialogOption<UnitBox> {
    private int index;
    private List<Column> columns;
    private Consumer<Column> selectListener;

    public DownloadDialogOption(UnitBox box) {
        super(box);
    }

    public DownloadDialogOption index(int index) {
        this.index = index;
        return this;
    }

    public DownloadDialogOption columns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public DownloadDialogOption onSelect(Consumer<Column> listener) {
        this.selectListener = listener;
        return this;
    }

    public Column selectedColumn() {
        String option = this.options.selection().size() > 0 ? (String)this.options.selection().get(0) : null;
        option = option != null && option.equals(this.translate("None")) ? null : option;
        return this.findColumn(option);
    }

    private Column findColumn(String option) {
        if (option == null) {
            return null;
        }
        return this.columns.stream().filter(c -> c.label().equals(option)).findFirst().orElse(null);
    }

    @Override
    public void init() {
        super.init();
        this.options.onSelect(e -> this.notifySelect());
    }

    public void refresh() {
        super.refresh();
        this.name.value(this.translate("Column") + " " + (this.index + 1));
        Column selected = this.selectedColumn();
        this.options.clear();
        this.options.add(this.translate("None"));
        this.options.addAll(this.columns.stream().map(Column::label).collect(Collectors.toList()));
        if (selected != null) {
            this.options.selection(new String[]{selected.label()});
        }
    }

    private void notifySelect() {
        this.selectListener.accept(this.selectedColumn());
    }
}

