/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.actions;

import io.intino.alexandria.http.spark.SparkContext;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.schemas.Attribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monet.metamodel.ContainerDefinition;
import org.monet.metamodel.Definition;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.space.kernel.components.ComponentPersistence;
import org.monet.space.kernel.components.layers.NodeLayer;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.map.Location;
import org.monet.space.kernel.model.map.LocationList;

public class GetLocationsAction {
    public UnitBox box;
    public SparkContext context;
    public String name;

    public List<io.intino.goros.unit.box.schemas.Location> execute() {
        Dictionary dictionary = Dictionary.getInstance();
        List definitionList = dictionary.getAllDefinitions().stream().filter(GetLocationsAction::isGeoreferencedDefinition).collect(Collectors.toList());
        if (this.name == null || this.name == "") {
            return null;
        }
        Definition definition = definitionList.stream().filter(d -> this.sameName((Definition)d, this.name)).findFirst().orElse(null);
        if (definition == null) {
            definition = definitionList.stream().filter(d -> this.sameLabel((Definition)d, this.name)).findFirst().orElse(null);
        }
        if (definition == null) {
            return null;
        }
        String code = definition.getCode();
        NodeLayer nodeLayer = ComponentPersistence.getInstance().getNodeLayer();
        LocationList locations = nodeLayer.loadLocations(code);
        ArrayList result = new ArrayList();
        locations.forEach(result::add);
        NodeDefinition nodeDefinition = Dictionary.getInstance().getNodeDefinition(code);
        IndexDefinition indexDefinition = Dictionary.getInstance().locateIndex(nodeDefinition);
        return result.stream().map(l -> this.changeType((Location)l, indexDefinition)).collect(Collectors.toList());
    }

    private boolean sameName(Definition definition, String name) {
        return definition.getName().equals(name);
    }

    private boolean sameLabel(Definition definition, String name) {
        return definition.getLabel().equals(name);
    }

    private static boolean isGeoreferencedDefinition(Definition definition) {
        if (definition instanceof ContainerDefinition) {
            return ((ContainerDefinition)definition).isGeoreferenced();
        }
        if (definition instanceof FormDefinition) {
            return ((FormDefinition)definition).isGeoreferenced();
        }
        return false;
    }

    private io.intino.goros.unit.box.schemas.Location changeType(Location l, IndexDefinition indexDefinition) {
        io.intino.goros.unit.box.schemas.Location result = new io.intino.goros.unit.box.schemas.Location();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        result.id(l.getNodeId());
        for (Map.Entry entry : l.getAttributes().entrySet()) {
            Attribute attribute = new Attribute();
            attribute.name((String)entry.getKey());
            attribute.label(indexDefinition.getAttribute((String)entry.getKey()).getLabel().toString());
            attribute.value((String)entry.getValue());
            attributes.add(attribute);
        }
        result.attributes(attributes);
        result.name(l.getLabel());
        result.latitude(l.getGeometry().getCentroid().getCoordinate().x);
        result.longitude(l.getGeometry().getCentroid().getCoordinate().y);
        return result;
    }

    public void onMalformedRequest(Throwable e) {
    }
}

