/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.DisplayProvider;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskPlaceEditionTemplate;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.monet.metamodel.EditionActionProperty;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.FormDefinitionBase;
import org.monet.metamodel.PlaceActionProperty;
import org.monet.space.kernel.components.layers.NodeLayer;
import org.monet.space.kernel.machines.ttm.model.ValidationResult;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.Task;

public class TaskPlaceEditionTemplate
extends AbstractTaskPlaceEditionTemplate<UnitBox> {
    private Task task;
    private EditionActionProperty property;
    private DisplayProvider displayProvider;

    public TaskPlaceEditionTemplate(UnitBox box) {
        super(box);
    }

    public TaskPlaceEditionTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskPlaceEditionTemplate property(EditionActionProperty property) {
        this.property = property;
        return this;
    }

    public TaskPlaceEditionTemplate displayProvider(DisplayProvider provider) {
        this.displayProvider = provider;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.solve.onExecute(e -> this.solve());
    }

    public void refresh() {
        super.refresh();
        Node form = this.loadForm();
        this.solve.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        this.solve.readonly(form == null);
        this.refreshForm(form);
        this.refreshNoEditionBlock(form);
    }

    private Node loadForm() {
        String formId = this.task.getProcess().getEditionFormId();
        NodeLayer nodeLayer = LayerHelper.nodeLayer();
        return this.formDefined(formId) && nodeLayer.existsNode(formId) ? nodeLayer.loadNode(formId) : null;
    }

    private void refreshForm(Node form) {
        this.formFrame.clear();
        if (form == null) {
            return;
        }
        EditionActionProperty.UseProperty use = this.property.getUse();
        FormDefinition definition = Dictionary.getInstance().getFormDefinition(use.getForm().getValue());
        FormDefinitionBase.FormViewProperty view = (FormDefinitionBase.FormViewProperty)definition.getViewMap().get(use.getWithView().getValue());
        Display display = this.displayProvider.displayFor(form, view != null ? view.getCode() : null);
        if (display == null) {
            return;
        }
        this.formFrame.display(display);
        display.refresh();
    }

    private void refreshNoEditionBlock(Node form) {
        this.noEditionBlock.visible(form == null);
    }

    private boolean formDefined(String id) {
        return id != null && !id.isEmpty();
    }

    private void solve() {
        try {
            this.solve.readonly(true);
            ValidationResult validation = this.task.getProcess().solveEditionAction();
            this.solveErrorMessageBlock.visible(!validation.isValid());
            if (!validation.isValid()) {
                this.solveErrorMessage.value(this.solveErrorMessage(validation));
            }
        }
        finally {
            this.solve.readonly(false);
            this.notifyUser(this.translate("Task resolved"), UserMessage.Type.Success);
        }
    }

    private String solveErrorMessage(ValidationResult validation) {
        LinkedHashMap errorsMap = validation.getErrors();
        String message = errorsMap.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(", "));
        return message.isEmpty() ? this.translate("It could not solve task edition") : message;
    }
}

