/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractRolesTemplate;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.LayerHelper;
import java.util.List;
import org.monet.space.kernel.model.Role;

public class RolesTemplate
extends AbstractRolesTemplate<UnitBox> {
    private Role selectedRole;

    public RolesTemplate(UnitBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.initToolbars();
        this.initViews();
    }

    private void initToolbars() {
        this.filters.onToggle(e -> this.toggleFiltersViewVisibility(e.state()));
    }

    public void didMount() {
        super.didMount();
        this.tableView.show();
    }

    public void refresh() {
        super.refresh();
        this.refreshToolbars();
        this.refreshView();
        if (!this.tableView.isVisible()) {
            this.tableView.show();
        }
        if (!this.roleView.isVisible() && this.filters.state() != ToggleEvent.State.On) {
            this.filters.toggle();
        }
    }

    private void initViews() {
        this.tableView.onInit(e -> {
            this.tableView.tableViewStamp.rolesTable.onRefreshItemCount(this::refreshCount);
            this.tableView.tableViewStamp.rolesTable.onSelect(this::open);
        });
        this.tableView.onShow(e -> {
            this.bindCurrentViewTo((Collection)this.tableView.tableViewStamp.rolesTable);
            this.search.bindTo(new Collection[]{this.tableView.tableViewStamp.rolesTable});
            this.tableView.tableViewStamp.refresh();
        });
        this.filtersView.onInit(e -> this.initFilters());
        this.roleView.onInit(e -> this.bindCurrentViewTo(this.currentCollection()));
        this.roleView.onShow(e -> {
            this.roleView.roleStamp.role(this.reloadSelected());
            this.roleView.roleStamp.onChange(this::refresh);
            this.roleView.roleStamp.refresh();
        });
    }

    private void initFilters() {
        this.filtersView.rolesFiltersStamp.bindTo(this.currentCollection());
        this.filtersView.rolesFiltersStamp.refresh();
    }

    private void refreshToolbars() {
        this.toolbar.onAdd(role -> {
            this.refresh();
            this.select((Role)role);
        });
        this.toolbar.refresh();
    }

    private void refreshCount(RefreshCountEvent event) {
        this.count.value(Formatters.countMessage(event.count(), this.translate("role"), this.translate("roles")));
    }

    private void refreshView() {
        if (this.tableView.isVisible()) {
            this.tableView.tableViewStamp.refresh();
        }
    }

    private void refreshFilters() {
        this.filtersView.rolesFiltersStamp.refresh();
    }

    private void bindCurrentViewTo(Collection collection) {
        if (this.roleView.isVisible()) {
            this.roleView.roleStamp.bindTo(collection);
        }
    }

    private Collection currentCollection() {
        return this.tableView.tableViewStamp.rolesTable;
    }

    private Role reloadSelected() {
        if (this.selectedRole == null) {
            return null;
        }
        return LayerHelper.roleLayer().loadRole(this.selectedRole.getId());
    }

    private void toggleFiltersViewVisibility(ToggleEvent.State state) {
        this.roleView.hide();
        if (state == ToggleEvent.State.On) {
            this.filtersView.show();
        } else {
            this.filtersView.hide();
        }
    }

    private void updateRolePageVisibility(boolean visible) {
        if (visible) {
            if (this.filtersView.isVisible()) {
                this.filters.toggle(ToggleEvent.State.Off);
            }
            this.roleView.show();
        } else {
            this.roleView.hide();
        }
    }

    private void refresh(Role role) {
        if (this.tableView.isVisible()) {
            this.tableView.tableViewStamp.refresh(role);
        }
    }

    private void select(Role role) {
        if (this.tableView.isVisible()) {
            this.tableView.tableViewStamp.select(role);
        }
    }

    private void open(SelectionEvent event) {
        List selection = event.selection();
        this.open(selection.size() > 0 ? (Role)selection.get(0) : null);
    }

    private void open(Role role) {
        this.selectedRole = this.roleView.isVisible() && role == null ? null : role;
        this.updateRolePageVisibility(this.selectedRole != null);
    }

    private void close() {
        this.selectedRole = null;
        this.updateRolePageVisibility(false);
    }
}

