/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.DatasourceHelper;
import io.intino.goros.unit.util.LayerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.RoleDefinition;
import org.monet.space.kernel.model.FederationUnitService;

public class FederationUnitServiceListDatasource
extends PageDatasource<FederationUnitService> {
    private final UnitBox box;
    private final UISession session;
    private final RoleDefinition roleDefinition;

    public FederationUnitServiceListDatasource(UnitBox box, UISession session, RoleDefinition roleDefinition) {
        this.box = box;
        this.session = session;
        this.roleDefinition = roleDefinition;
    }

    public List<FederationUnitService> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        ArrayList<FederationUnitService> result = new ArrayList<FederationUnitService>(this.filter(FederationUnitServiceListDatasource.federationUnitsServices(this.box, this.session, this.roleDefinition), condition, filters));
        int from = Math.min(start, result.size());
        int end = Math.min(start + count, result.size());
        return result.subList(from, end);
    }

    public long itemCount(String condition, List<Filter> filters) {
        return FederationUnitServiceListDatasource.federationUnitsServices(this.box, this.session, this.roleDefinition).size();
    }

    public List<Group> groups(String key) {
        return Collections.emptyList();
    }

    private static List<FederationUnitService> federationUnitsServices(UnitBox box, UISession session, RoleDefinition definition) {
        if (definition == null) {
            return Collections.emptyList();
        }
        box.linkSession(session);
        ArrayList federationUnitList = new ArrayList(LayerHelper.federationLayer(session).loadPartners().get().values());
        return federationUnitList.stream().map(fu -> fu.getServiceList().get().values()).flatMap(Collection::stream).filter(service -> FederationUnitServiceListDatasource.conforms(service, definition)).collect(Collectors.toList());
    }

    private List<FederationUnitService> filter(List<FederationUnitService> federationUnitsServices, String condition, List<Filter> filters) {
        if (condition == null) {
            return federationUnitsServices;
        }
        String[] lowerCondition = condition.toLowerCase().split(" ");
        return federationUnitsServices.stream().filter(fu -> DatasourceHelper.matches(fu.getLabel(), lowerCondition) || DatasourceHelper.matches(fu.getName(), lowerCondition) || DatasourceHelper.matches(DatasourceHelper.partnerLabel(this.session, fu), lowerCondition)).collect(Collectors.toList());
    }

    private static boolean conforms(FederationUnitService service, RoleDefinition definition) {
        return FederationUnitServiceListDatasource.ontologies(definition).contains(service.getOntology());
    }

    private static List<String> ontologies(RoleDefinition definition) {
        if (definition.getEnableServices() != null) {
            return definition.getEnableServices().getOntology();
        }
        return Collections.emptyList();
    }
}

