/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.util;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.printers.TaskListPrinter;
import io.intino.goros.unit.util.AccountHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.PathHelper;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.Definition;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.MonetLink;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.TaskSearchRequest;
import org.monet.space.office.presentation.user.renders.TaskListPrintRender;

public class TaskHelper {
    public static Task taskOf(MonetLink link) {
        if (link == null) {
            return null;
        }
        return LayerHelper.taskLayer().loadTask(link.getId());
    }

    public static InputStream download(UnitBox box, TaskSearchRequest request, String format, String language, List<String> columns, UISession session) {
        return new TaskListPrinter(box, AccountHelper.account(session), request, format, columns).print(language);
    }

    public static List<Column> downloadColumns(String language) {
        return TaskListPrintRender.attributes.stream().map(a -> TaskHelper.columnOf(a, language)).collect(Collectors.toList());
    }

    private static Column columnOf(String attribute, String language) {
        language = TaskListPrintRender.attributesLabels.containsKey(language) ? language : "es";
        List translations = (List)TaskListPrintRender.attributesLabels.get(language);
        return new Column().code(attribute).label((String)translations.get(TaskHelper.positionOf(attribute)));
    }

    private static int positionOf(String attribute) {
        int pos = 0;
        for (String currentAttribute : TaskListPrintRender.attributes) {
            if (currentAttribute.equals(attribute)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public static boolean isAlive(Task task) {
        return !task.isExpired() && !task.isAborted() && !task.isFinished();
    }

    public static String nameOf(Task task) {
        return PathHelper.nameOf((Definition)task.getDefinition());
    }

    public static List<DataRequest.SortBy> sortsByOf(List<String> sortings) {
        if (sortings == null) {
            return Collections.emptyList();
        }
        return sortings.stream().map(TaskHelper::sortByOf).collect(Collectors.toList());
    }

    public static String state(Task task) {
        if (task.isNew()) {
            return "New";
        }
        if (task.isPending()) {
            return "Pending";
        }
        if (task.isWaiting()) {
            return "Waiting";
        }
        if (task.isExpired()) {
            return "Expired";
        }
        if (task.isFinished()) {
            return "Finished";
        }
        if (task.isAborted()) {
            return "Aborted";
        }
        if (task.isFailure()) {
            return "Failure";
        }
        return null;
    }

    public static String stateColor(Task task) {
        if (task.isNew()) {
            return "#4CAF50";
        }
        if (task.isPending()) {
            return "#4CAF50";
        }
        if (task.isWaiting()) {
            return "#2896F3";
        }
        if (task.isExpired()) {
            return "#F44235";
        }
        if (task.isFinished()) {
            return "#272C34";
        }
        if (task.isAborted()) {
            return "#F44235";
        }
        if (task.isFailure()) {
            return "#F44235";
        }
        return null;
    }

    public static long yearsToMillis(int count) {
        return (long)count * 12L * TaskHelper.monthsToMillis(1);
    }

    public static long monthsToMillis(int count) {
        return (long)count * 30L * TaskHelper.daysToMillis(1);
    }

    public static long weeksToMillis(int count) {
        return (long)count * 7L * TaskHelper.daysToMillis(1);
    }

    public static long daysToMillis(int count) {
        return (long)count * 24L * TaskHelper.hoursToMillis(1);
    }

    public static long hoursToMillis(int count) {
        return (long)count * 60L * TaskHelper.minutesToMillis(1);
    }

    public static long minutesToMillis(int count) {
        return (long)count * 60L * TaskHelper.secondsToMillis(1);
    }

    public static long secondsToMillis(int count) {
        return (long)count * 1000L;
    }

    private static DataRequest.SortBy sortByOf(String sorting) {
        final String[] split = sorting.split("#");
        return new DataRequest.SortBy(){

            public String attribute() {
                return split[0];
            }

            public String mode() {
                return split.length > 1 ? split[1] : "ASC";
            }
        };
    }
}

