/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskFolderGrouping;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTasksFiltersTemplate;
import org.monet.space.kernel.model.Task;

public class TasksFiltersTemplate
extends AbstractTasksFiltersTemplate<UnitBox> {
    private Task task;
    private boolean readonly = true;
    private Collection collection;

    public TasksFiltersTemplate(UnitBox box) {
        super(box);
    }

    public TasksFiltersTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TasksFiltersTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public TasksFiltersTemplate bindTo(Collection collection) {
        this.collection = collection;
        this.updateFilters();
        this.folder.select(TaskFolderGrouping.Active);
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.reset.onExecute(e -> this.resetFilters());
    }

    public void refresh() {
        super.refresh();
        this.folder.multipleSelection(false);
        this.nature.multipleSelection(false);
        this.type.multipleSelection(false);
    }

    private void updateFilters() {
        this.udpateFolder();
        this.udpateNature();
        this.udpateUrgent();
        this.updateType();
    }

    private void resetFilters() {
        this.folder.clearSelection();
        this.nature.clearSelection();
        this.urgent.clearSelection();
        this.type.clearSelection();
        this.collection.clearFilters();
    }

    private void udpateFolder() {
        this.folder.label(this.translate("Folder"));
        this.folder.attribute("folder");
        this.folder.multipleSelection(false);
        this.folder.bindTo(this.collection);
        this.folder.refresh();
    }

    private void udpateNature() {
        this.nature.label(this.translate("Nature"));
        this.nature.attribute("nature");
        this.nature.multipleSelection(false);
        this.nature.bindTo(this.collection);
        this.nature.refresh();
    }

    private void udpateUrgent() {
        this.urgent.label(this.translate("Urgents"));
        this.urgent.attribute("urgent");
        this.urgent.bindTo(this.collection);
        this.urgent.refresh();
    }

    private void updateType() {
        this.type.label(this.translate("Type"));
        this.type.attribute("type");
        this.type.multipleSelection(false);
        this.type.bindTo(this.collection);
        this.type.refresh();
    }
}

