/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.UserListDatasource;
import io.intino.goros.unit.box.ui.displays.rows.AssignTaskDialogTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskToolbarTemplate;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.TaskHelper;
import java.util.function.Consumer;
import org.monet.space.kernel.components.layers.TaskLayer;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.User;

public class TaskToolbarTemplate
extends AbstractTaskToolbarTemplate<UnitBox> {
    private Task task;
    private boolean readonly = true;
    private Consumer<Task> updateListener;
    private Consumer<Task> changeListener;
    private Consumer<Task> abortListener;
    private User selectedUser;

    public TaskToolbarTemplate(UnitBox box) {
        super(box);
    }

    public TaskToolbarTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskToolbarTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public TaskToolbarTemplate onUpdate(Consumer<Task> listener) {
        this.updateListener = listener;
        return this;
    }

    public TaskToolbarTemplate onChange(Consumer<Task> listener) {
        this.changeListener = listener;
        return this;
    }

    public TaskToolbarTemplate onAbort(Consumer<Task> listener) {
        this.abortListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.update.onExecute(e -> this.updateTask());
        this.abort.onExecute(e -> this.abort());
        this.unAssign.onExecute(e -> this.unAssign());
        this.initAssignDialog();
    }

    public void refresh() {
        super.refresh();
        if (this.task == null) {
            return;
        }
        this.assign.visible(!this.readonly && TaskHelper.isAlive(this.task) && this.task.getOwner() == null);
        this.unAssign.visible(!this.readonly && TaskHelper.isAlive(this.task) && this.task.getOwner() != null);
        this.abort.visible(!this.readonly && TaskHelper.isAlive(this.task));
    }

    private void initAssignDialog() {
        this.accept.onExecute(e -> this.assign(this.selectedUser, this.reason.value()));
        this.initUsersTable();
        this.assignTaskOwnerDialogBox.onOpen(e -> {
            this.selectedUser = null;
            this.assignTaskOwnerDialogBox.title(this.translate("Assign task ::title:: to user...").replace("::title::", this.task.getLabel()));
            this.refreshAssignDialog();
        });
    }

    private void updateTask() {
        this.updateListener.accept(LayerHelper.taskLayer().loadTask(this.task.getId()));
    }

    private void abort() {
        this.unAssign.readonly(true);
        this.notifyUser(this.translate("Unassigning task..."), UserMessage.Type.Loading);
        TaskLayer taskLayer = LayerHelper.taskLayer();
        taskLayer.abortTask(this.task.getId());
        this.notifyUser(this.translate("Task unassigned"), UserMessage.Type.Success);
        this.task(taskLayer.loadTask(this.task.getId()));
        this.abortListener.accept(this.task);
        this.unAssign.readonly(false);
    }

    private void assign(User user, String reason) {
        this.assign.readonly(true);
        this.assignTaskOwnerDialogBox.close();
        this.notifyUser(this.translate("Assigning task..."), UserMessage.Type.Loading);
        this.saveTaskOwner(user, reason);
        this.notifyUser(this.translate("Task assigned"), UserMessage.Type.Success);
        this.refresh();
        this.changeListener.accept(this.task);
        this.assign.readonly(false);
    }

    private void unAssign() {
        this.saveTaskOwner(null, "");
        this.refresh();
        this.changeListener.accept(this.task);
    }

    private void saveTaskOwner(User user, String reason) {
        LayerHelper.taskLayer().saveTaskOwner(this.task, user, reason);
    }

    private void initUsersTable() {
        this.assignTaskDialogTable.onSelect(e -> {
            this.selectedUser = e.selection().size() > 0 ? (User)e.selection().get(0) : null;
            this.refreshAssignDialogToolbar();
        });
        this.assignTaskDialogTable.onAddItem(e -> {
            User user = (User)e.item();
            AssignTaskDialogTableRow row = (AssignTaskDialogTableRow)e.component();
            row.assignTaskDialogTableFullnameItem.fullName.value(user.getInfo().getFullname());
            row.assignTaskDialogTableEmailItem.email.value(user.getInfo().getEmail());
        });
    }

    private void refreshAssignDialog() {
        this.refreshUsersTable();
        this.refreshAssignDialogToolbar();
    }

    private void refreshUsersTable() {
        this.assignTaskDialogTable.source((Datasource)new UserListDatasource((UnitBox)this.box(), this.session(), false));
        this.assignTaskDialogTable.reload();
    }

    private void refreshAssignDialogToolbar() {
        this.accept.readonly(this.selectedUser == null);
    }
}

