/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.DisplayProvider;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskPlaceSendJobTemplate;
import io.intino.goros.unit.box.ui.displays.templates.TaskPlaceRoleTemplate;
import io.intino.goros.unit.util.AccountHelper;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.RoleHelper;
import org.monet.bpi.java.FieldBooleanImpl;
import org.monet.bpi.java.FieldDateImpl;
import org.monet.bpi.java.FieldTextImpl;
import org.monet.bpi.types.Date;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.PlaceActionProperty;
import org.monet.metamodel.RoleDefinition;
import org.monet.metamodel.SendJobActionProperty;
import org.monet.space.kernel.model.Attribute;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.Role;
import org.monet.space.kernel.model.RoleList;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.TaskOrder;

public class TaskPlaceSendJobTemplate
extends AbstractTaskPlaceSendJobTemplate<UnitBox> {
    private Task task;
    private SendJobActionProperty property;
    private DisplayProvider displayProvider;

    public TaskPlaceSendJobTemplate(UnitBox box) {
        super(box);
    }

    public TaskPlaceSendJobTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskPlaceSendJobTemplate property(SendJobActionProperty property) {
        this.property = property;
        return this;
    }

    public TaskPlaceSendJobTemplate displayProvider(DisplayProvider provider) {
        this.displayProvider = provider;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.waitingView.onShow(e -> this.refreshWaitingView());
        this.pendingView.onShow(e -> {
            this.pendingView.setupBlock.setupToolbar.solveSetup.onExecute(e1 -> this.setup());
            this.pendingView.rolesSetupBlock.unAssignedRole.onExecute(e1 -> this.selectNone());
            this.refreshPendingView();
        });
        this.failureView.onShow(e -> this.refreshFailureView());
    }

    public void refresh() {
        super.refresh();
        this.label.value(Language.getInstance().getModelResource(this.property.getLabel()));
        this.waitingView.visible(this.task.isWaiting());
        this.pendingView.visible(this.task.isPending());
        this.failureView.visible(this.task.isFailure());
        this.refreshView();
    }

    private void refreshView() {
        if (this.pendingView.isVisible()) {
            this.refreshPendingView();
        } else if (this.waitingView.isVisible()) {
            this.refreshWaitingView();
        } else if (this.failureView.isVisible()) {
            this.refreshFailureView();
        }
    }

    private void refreshWaitingView() {
        if (!this.task.isWaiting()) {
            return;
        }
    }

    private void refreshPendingView() {
        if (!this.task.isPending()) {
            return;
        }
        if (this.property.getMode() != null && this.property.getMode() == SendJobActionProperty.ModeEnumeration.AUTOMATIC) {
            return;
        }
        TaskOrder order = this.order();
        this.refreshSelectRoleStep(order);
        this.refreshSetupStep(order);
    }

    private void refreshSelectRoleStep(TaskOrder order) {
        boolean roleSelected = order != null && order.getRole() != null;
        this.pendingView.rolesSetupBlock.visible(!roleSelected);
        if (roleSelected) {
            return;
        }
        RoleList roleList = this.roles();
        this.pendingView.rolesSetupBlock.openRoles.visible(roleList.getTotalCount() <= 0);
        this.pendingView.rolesSetupBlock.openRoles.address(path -> "/permisos");
        this.pendingView.rolesSetupBlock.openRoles.readonly(!RoleHelper.canAccessRoles(this.session()));
        this.pendingView.rolesSetupBlock.unAssignedRole.affirmed(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        this.pendingView.setupBlock.setupToolbar.solveSetup.readonly(roleList.getTotalCount() <= 0);
        if (roleList.getTotalCount() <= 0) {
            String label = Language.getInstance().getModelResource(this.roleDefinition().getLabel());
            this.pendingView.pendingMessage.value(this.translate("No roles of type ::role:: defined for job").replace("::role::", label));
            return;
        }
        this.pendingView.pendingMessage.value(this.translate("Select user to whom send order:"));
        this.pendingView.rolesSetupBlock.roles.clear();
        roleList.get().values().forEach(role -> this.fill((Role)role, (TaskPlaceRoleTemplate)this.pendingView.rolesSetupBlock.roles.add()));
    }

    private void refreshSetupStep(TaskOrder order) {
        boolean roleNotSelected = order == null || order.getRole() == null || order.getSetupNodeId() == null;
        this.pendingView.setupBlock.visible(!roleNotSelected);
        if (roleNotSelected) {
            return;
        }
        Node setupNode = this.setupNode(order);
        Role role = order.getRole();
        this.pendingView.rolesSetupBlock.openRoles.visible(false);
        this.pendingView.rolesSetupBlock.unAssignedRole.visible(false);
        if (setupNode == null) {
            this.pendingView.pendingMessage.value(this.translate("Sending order..."));
        } else {
            this.pendingView.pendingMessage.value(this.translate("Setup order for ::role::").replace("::role::", role.getLabel()));
            this.refreshSetupForm(setupNode);
        }
    }

    private void refreshSetupForm(Node form) {
        this.pendingView.setupBlock.setupFrame.clear();
        if (form == null) {
            return;
        }
        NodeViewProperty viewProperty = DisplayHelper.defaultEmbeddedView(form);
        Display display = this.displayProvider.displayFor(form, viewProperty != null ? viewProperty.getCode() : null);
        if (display == null) {
            return;
        }
        this.pendingView.setupBlock.setupFrame.display(display);
        display.refresh();
    }

    private void refreshFailureView() {
    }

    private void fill(Role role, TaskPlaceRoleTemplate view) {
        view.role(role);
        view.confirmText(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        view.onSelect(e -> {
            view.readonly(true);
            this.select(role);
        });
        view.refresh();
    }

    private void select(Role role) {
        this.task.getProcess().selectSendJobActionRole(role);
        this.refresh();
    }

    private void selectNone() {
        this.unAssignedRole.readonly(true);
        this.select(null);
    }

    private void setup() {
        this.notifyUser(this.translate("Setting up job..."), UserMessage.Type.Loading);
        this.solveSetup.readonly(true);
        this.fillOrder();
        this.task.getProcess().setupSendJobAction();
        this.solveSetup.readonly(false);
        this.notifyUser(this.translate("Job setup"), UserMessage.Type.Success);
    }

    private void fillOrder() {
        TaskOrder order = this.order();
        if (order == null) {
            return;
        }
        Node setupNode = this.setupNode(order);
        if (setupNode == null) {
            return;
        }
        Date startDate = FieldDateImpl.get((Attribute)setupNode.getAttribute("_vrwtkw"));
        Date endDate = FieldDateImpl.get((Attribute)setupNode.getAttribute("_7vewhg"));
        order.setSuggestedStartDate(startDate != null ? startDate.getValue() : null);
        order.setSuggestedEndDate(endDate != null ? endDate.getValue() : null);
        order.setComments(FieldTextImpl.get((Attribute)setupNode.getAttribute("_y__kmq")));
        order.setUrgent(FieldBooleanImpl.get((Attribute)setupNode.getAttribute("_ss7omw")).booleanValue());
        LayerHelper.taskLayer().saveTaskOrder(order);
    }

    private TaskOrder order() {
        String orderId = this.task.getProcess().getCurrentJobOrderId();
        return orderId != null ? LayerHelper.taskLayer().loadTaskOrder(orderId) : null;
    }

    private Node setupNode(TaskOrder order) {
        return order.getSetupNodeId() != null ? LayerHelper.nodeLayer().loadNode(order.getSetupNodeId()) : null;
    }

    private RoleList roles() {
        RoleDefinition roleDefinition = this.roleDefinition();
        return AccountHelper.loadNonExpiredRoleList(roleDefinition.getCode(), Role.Nature.Internal);
    }

    private RoleDefinition roleDefinition() {
        return Dictionary.getInstance().getRoleDefinition(this.property.getRole().getValue());
    }
}

