/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.FederationUnitFeederListDatasource;
import io.intino.goros.unit.box.ui.datasources.FederationUnitServiceListDatasource;
import io.intino.goros.unit.box.ui.datasources.UserListDatasource;
import io.intino.goros.unit.box.ui.datasources.model.role.RoleTypeGrouping;
import io.intino.goros.unit.box.ui.displays.rows.AddRoleFeederTableRow;
import io.intino.goros.unit.box.ui.displays.rows.AddRoleServiceTableRow;
import io.intino.goros.unit.box.ui.displays.rows.AddRoleUserTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractRolesToolbarTemplate;
import io.intino.goros.unit.util.AccountHelper;
import io.intino.goros.unit.util.LayerHelper;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.monet.metamodel.RoleDefinition;
import org.monet.space.kernel.components.layers.FederationLayer;
import org.monet.space.kernel.components.layers.RoleLayer;
import org.monet.space.kernel.model.Account;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.FederationUnit;
import org.monet.space.kernel.model.FederationUnitFeeder;
import org.monet.space.kernel.model.FederationUnitService;
import org.monet.space.kernel.model.Role;
import org.monet.space.kernel.model.User;
import org.monet.space.kernel.model.UserInfo;

public class RolesToolbarTemplate
extends AbstractRolesToolbarTemplate<UnitBox> {
    private Consumer<Role> addListener;
    private User selectedUser = null;
    private FederationUnitService selectedService = null;
    private FederationUnitFeeder selectedFeeder = null;

    public RolesToolbarTemplate(UnitBox box) {
        super(box);
    }

    public RolesToolbarTemplate onAdd(Consumer<Role> listener) {
        this.addListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initAddDialog();
    }

    private void initAddDialog() {
        this.accept.onExecute(e -> this.addRole());
        this.type.onSelect(e -> {
            if (e.selection().size() <= 0) {
                return;
            }
            this.updateDefinitions(RoleTypeGrouping.from((String)e.selection().get(0)));
        });
        this.definition.onSelect(e -> {
            if (e.selection().size() <= 0) {
                return;
            }
            this.clearSelection();
            this.showRoleView();
        });
        this.addRoleDialog.onOpen(e -> this.refreshAddDialog());
        this.initAddUserRole();
        this.initAddServiceRole();
        this.initAddFeederRole();
    }

    private void initAddUserRole() {
        this.userRoleBlock.onInit(e -> {
            this.userRoleBlock.addRoleUserTable.onSelect(e1 -> {
                this.selectedUser = e1.selection().size() > 0 ? (User)e1.selection().get(0) : null;
            });
            this.userRoleBlock.addRoleUserTable.onAddItem(e1 -> {
                User user = (User)e1.item();
                AddRoleUserTableRow row = (AddRoleUserTableRow)e1.component();
                row.addRoleUserTableFullnameItem.fullName.value(user.getInfo().getFullname());
                row.addRoleUserTableEmailItem.email.value(user.getInfo().getEmail());
            });
        });
        this.userRoleBlock.onShow(e -> {
            this.userRoleBlock.addRoleUserTable.source((Datasource)new UserListDatasource((UnitBox)this.box(), this.session(), true));
            this.userRoleBlock.addRoleUserTable.reload();
        });
    }

    private void initAddServiceRole() {
        this.serviceRoleBlock.onInit(e -> {
            this.serviceRoleBlock.addRoleServiceTable.onSelect(e1 -> {
                this.selectedService = e1.selection().size() > 0 ? (FederationUnitService)e1.selection().get(0) : null;
            });
            this.serviceRoleBlock.addRoleServiceTable.onAddItem(e1 -> {
                FederationUnitService service = (FederationUnitService)e1.item();
                AddRoleServiceTableRow row = (AddRoleServiceTableRow)e1.component();
                row.addRoleServiceTableLabelItem.label.value(service.getLabel());
                row.addRoleServiceTablePartnerItem.partner.value(this.partnerLabel(service.getPartnerId()));
            });
        });
        this.serviceRoleBlock.onShow(e -> {
            this.serviceRoleBlock.addRoleServiceTable.source((Datasource)new FederationUnitServiceListDatasource((UnitBox)this.box(), this.session(), this.roleDefinition()));
            this.serviceRoleBlock.addRoleServiceTable.reload();
        });
    }

    private void initAddFeederRole() {
        this.feederRoleBlock.onInit(e -> {
            this.feederRoleBlock.addRoleFeederTable.onSelect(e1 -> {
                this.selectedFeeder = e1.selection().size() > 0 ? (FederationUnitFeeder)e1.selection().get(0) : null;
            });
            this.feederRoleBlock.addRoleFeederTable.onAddItem(e1 -> {
                FederationUnitFeeder feeder = (FederationUnitFeeder)e1.item();
                AddRoleFeederTableRow row = (AddRoleFeederTableRow)e1.component();
                row.addRoleFeederTableLabelItem.label.value(feeder.getLabel());
                row.addRoleFeederTablePartnerItem.partner.value(this.partnerLabel(feeder.getPartnerId()));
            });
        });
        this.feederRoleBlock.onShow(e -> {
            this.feederRoleBlock.addRoleFeederTable.source((Datasource)new FederationUnitFeederListDatasource((UnitBox)this.box(), this.session(), this.roleDefinition()));
            this.feederRoleBlock.addRoleFeederTable.reload();
        });
    }

    private void showRoleView() {
        RoleTypeGrouping role = RoleTypeGrouping.from((String)this.type.selection().get(0));
        if (role == RoleTypeGrouping.User) {
            this.showUserView();
        } else if (role == RoleTypeGrouping.Service) {
            this.showServiceView();
        } else if (role == RoleTypeGrouping.Feeder) {
            this.showFeederView();
        }
    }

    private void updateDefinitions(RoleTypeGrouping role) {
        this.definition.clear();
        this.definition.select(new String[0]);
        this.clearSelection();
        Dictionary.getInstance().getRoleDefinitionList().stream().filter(rd -> this.conforms((RoleDefinition)rd, role)).forEach(rd -> this.definition.add(rd.getLabelString()));
        this.hideViews();
    }

    private boolean conforms(RoleDefinition definition, RoleTypeGrouping role) {
        if (role == RoleTypeGrouping.User && definition.getDisableUsers() == null) {
            return true;
        }
        if (role == RoleTypeGrouping.Service && definition.getEnableServices() != null) {
            return true;
        }
        return role == RoleTypeGrouping.Feeder && definition.getEnableFeeders() != null;
    }

    private void refreshAddDialog() {
        this.definition.clear();
        this.definition.select(new String[0]);
        this.type.clear();
        this.type.select(new String[0]);
        this.endDate.value(null);
        this.hideViews();
        Arrays.stream(RoleTypeGrouping.values()).forEach(v -> this.type.add(v.title()));
    }

    private void addRole() {
        Date expireValue;
        if (!this.check()) {
            return;
        }
        String definitionValue = (String)this.definition.selection().get(0);
        RoleDefinition roleDefinition = this.findDefinitionCode((String)this.definition.selection().get(0));
        RoleTypeGrouping typeValue = RoleTypeGrouping.from((String)this.type.selection().get(0));
        Date beginValue = Date.from(this.beginDate.value() != null ? this.beginDate.value() : Instant.now());
        Date date = expireValue = this.endDate.value() != null ? Date.from(this.endDate.value()) : null;
        if (this.existNonExpiredRole(definitionValue, roleDefinition)) {
            return;
        }
        this.addRoleDialog.close();
        Account account = this.registerAccount(typeValue);
        RoleLayer roleLayer = LayerHelper.roleLayer();
        Role role = typeValue == RoleTypeGrouping.User ? roleLayer.addUserRole(roleDefinition.getCode(), this.selectedUser, beginValue, expireValue) : (typeValue == RoleTypeGrouping.Service ? roleLayer.addServiceRole(roleDefinition.getCode(), this.partner(this.selectedService), this.selectedService, beginValue, expireValue) : roleLayer.addFeederRole(roleDefinition.getCode(), this.partner(this.selectedFeeder), this.selectedFeeder, beginValue, expireValue));
        LayerHelper.federationLayer(this.session()).createOrUpdateAccount(account);
        this.addListener.accept(role);
    }

    private Account registerAccount(RoleTypeGrouping typeValue) {
        if (typeValue != RoleTypeGrouping.User) {
            return AccountHelper.account(this.session());
        }
        FederationLayer federationLayer = LayerHelper.federationLayer(this.session());
        Account account = federationLayer.locateAccount(this.selectedUser.getName());
        if (account == null) {
            UserInfo userInfo = new UserInfo();
            userInfo.setFullname(this.selectedUser.getName());
            account = federationLayer.createAccount(null, this.selectedUser.getName(), userInfo);
        }
        return account;
    }

    private boolean existNonExpiredRole(String definitionValue, RoleDefinition roleDefinition) {
        RoleLayer roleLayer = LayerHelper.roleLayer();
        if (this.selectedUser != null && roleLayer.existsNonExpiredUserRole(roleDefinition.getCode(), this.selectedUser.getId())) {
            String message = this.translate("Role ::role:: is already active for ::user::").replace("::role::", definitionValue).replace("::user::", this.selectedUser.getInfo().getFullname());
            this.notifyUser(message, UserMessage.Type.Error);
            return true;
        }
        if (this.selectedService != null && roleLayer.existsNonExpiredServiceRole(roleDefinition.getCode(), this.partner(this.selectedService), this.selectedService)) {
            String message = this.translate("Role ::role:: is already active for ::service::").replace("::role::", definitionValue).replace("::service::", this.selectedService.getLabel());
            this.notifyUser(message, UserMessage.Type.Error);
            return true;
        }
        if (this.selectedFeeder != null && roleLayer.existsNonExpiredFeederRole(roleDefinition.getCode(), this.partner(this.selectedFeeder), this.selectedFeeder)) {
            String message = this.translate("Role ::role:: is already active for ::feeder::").replace("::role::", definitionValue).replace("::feeder::", this.selectedFeeder.getLabel());
            this.notifyUser(message, UserMessage.Type.Error);
            return true;
        }
        return false;
    }

    private RoleDefinition findDefinitionCode(String label) {
        return Dictionary.getInstance().getRoleDefinitionList().stream().filter(d -> d.getLabelString().equals(label)).findFirst().orElse(null);
    }

    private boolean check() {
        if (this.definition.selection().size() <= 0) {
            this.notifyUser(this.translate("Select class to add role"), UserMessage.Type.Error);
            return false;
        }
        if (this.type.selection().size() <= 0) {
            this.notifyUser(this.translate("Select type to add role"), UserMessage.Type.Error);
            return false;
        }
        RoleTypeGrouping typeValue = RoleTypeGrouping.from((String)this.type.selection().get(0));
        if (typeValue == RoleTypeGrouping.User && this.selectedUser == null) {
            this.notifyUser(this.translate("Select user to add role"), UserMessage.Type.Error);
            return false;
        }
        if (typeValue == RoleTypeGrouping.Service && this.selectedService == null) {
            this.notifyUser(this.translate("Select service partner to add role"), UserMessage.Type.Error);
            return false;
        }
        if (typeValue == RoleTypeGrouping.Feeder && this.selectedFeeder == null) {
            this.notifyUser(this.translate("Select feeder partner to add role"), UserMessage.Type.Error);
            return false;
        }
        return true;
    }

    private void hideViews() {
        this.serviceRoleBlock.hide();
        this.feederRoleBlock.hide();
        this.userRoleBlock.hide();
    }

    private void showUserView() {
        this.hideViews();
        this.userRoleBlock.show();
    }

    private void showServiceView() {
        this.hideViews();
        this.serviceRoleBlock.show();
    }

    private void showFeederView() {
        this.hideViews();
        this.feederRoleBlock.show();
    }

    private RoleDefinition roleDefinition() {
        return this.definition.selection().size() > 0 ? this.findDefinitionCode((String)this.definition.selection().get(0)) : null;
    }

    private String partnerLabel(String partnerId) {
        return this.partner(partnerId).getLabel();
    }

    private FederationUnit partner(FederationUnitService service) {
        return this.partner(service.getPartnerId());
    }

    private FederationUnit partner(FederationUnitFeeder feeder) {
        return this.partner(feeder.getPartnerId());
    }

    private FederationUnit partner(String partnerId) {
        return LayerHelper.federationLayer(this.session()).loadPartner(partnerId);
    }

    private void clearSelection() {
        this.selectedUser = null;
        this.selectedService = null;
        this.selectedFeeder = null;
    }
}

