/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.RoleListDatasource;
import io.intino.goros.unit.box.ui.datasources.model.role.RoleTypeGrouping;
import io.intino.goros.unit.box.ui.displays.rows.RolesTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractRolesTableCatalog;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.RoleHelper;
import org.monet.space.kernel.model.Role;

public class RolesTableCatalog
extends AbstractRolesTableCatalog<UnitBox> {
    public RolesTableCatalog(UnitBox box) {
        super(box);
    }

    public void select(Role role) {
        DisplayHelper.executeDelayed(b -> this.rolesTable.select(this.rolesTable.findItem(n -> ((Role)n).getId().equals(role.getId()))), 800L);
    }

    public void refresh(Role role) {
        this.rolesTable.refresh(this.rolesTable.findItem(n -> ((Role)n).getId().equals(role.getId())), role);
    }

    @Override
    public void init() {
        super.init();
        this.rolesTable.onAddItem(e -> {
            Role role = (Role)e.item();
            RolesTableRow row = (RolesTableRow)e.component();
            row.rolesTableUserItem.user.value(RoleHelper.userOf(role));
            row.rolesTableUserItem.state.value(this.translate(RoleHelper.stateLabel(role)));
            row.rolesTableUserItem.state.backgroundColor(RoleHelper.stateColor(role));
            row.rolesTableDefinitionItem.definition.value(RoleHelper.definitionLabelOf(role));
            row.rolesTableTypeItem.type.value(RoleTypeGrouping.from(role.getType().name()).title());
            row.rolesTableNatureItem.nature.value(RoleHelper.natureOf(role));
            row.rolesTableStartDateItem.startDate.value(role.getInternalBeginDate().toInstant());
            row.rolesTableEndDateItem.endDate.value(role.getInternalExpireDate() != null ? role.getInternalExpireDate().toInstant() : null);
        });
    }

    public void refresh() {
        super.refresh();
        if (this.rolesTable.source() == null) {
            this.rolesTable.source((Datasource)new RoleListDatasource((UnitBox)this.box(), this.session()));
        }
        this.rolesTable.reload();
    }
}

