/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.Geometry;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeLocationTemplate;
import io.intino.goros.unit.util.DictionaryHelper;
import io.intino.goros.unit.util.LayerHelper;
import org.monet.metamodel.AbstractManifestBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.map.GeometryHelper;
import org.monet.space.kernel.model.map.Location;

public class NodeLocationTemplate
extends AbstractNodeLocationTemplate<UnitBox> {
    private Node node;
    private NodeViewProperty view;
    private boolean readonly = true;

    public NodeLocationTemplate(UnitBox box) {
        super(box);
    }

    public NodeLocationTemplate node(Node node) {
        this.node = node;
        return this;
    }

    public NodeLocationTemplate view(String view) {
        this.view = view != null ? DictionaryHelper.view(this.node, view) : null;
        return this;
    }

    public NodeLocationTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    @Override
    public void init() {
        super.init();
        AbstractManifestBase.DefaultLocationProperty location = DictionaryHelper.defaultLocation();
        this.location.onChange(e -> this.saveLocation((Geometry)e.value()));
        if (location != null) {
            this.location.center(location.getLatitude(), location.getLongitude());
        }
    }

    public void refresh() {
        super.refresh();
        Location location = this.node.getLocation();
        this.location.value(location != null && location.getGeometry() != null ? location.getGeometry().toText() : null);
        if (location != null) {
            this.location.center(location.getGeometry().getCentroid().getX(), location.getGeometry().getCentroid().getY());
        }
        this.location.readonly(this.readonly);
    }

    private void saveLocation(Geometry geometry) {
        LayerHelper.nodeLayer().updateNodeLocation(this.node, geometry != null ? this.toMonetGeometry(geometry) : null);
    }

    private com.vividsolutions.jts.geom.Geometry toMonetGeometry(Geometry geometry) {
        try {
            GeometryFactory factory = GeometryHelper.getFactory();
            WKTReader reader = new WKTReader(factory);
            return reader.read(geometry.toWkt());
        }
        catch (ParseException e) {
            this.notifyUser(this.translate("Could not save new location"), UserMessage.Type.Error);
            Logger.error((Throwable)e);
            return null;
        }
    }
}

