/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractListFilterTemplate;
import java.util.List;

public class ListFilterTemplate
extends AbstractListFilterTemplate<UnitBox> {
    private String _label;
    private String attribute;
    private Collection collection;
    private boolean applyFilters = true;

    public ListFilterTemplate(UnitBox box) {
        super(box);
    }

    public ListFilterTemplate label(String label) {
        this._label = label;
        return this;
    }

    public ListFilterTemplate attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public ListFilterTemplate bindTo(Collection collection) {
        this.collection = collection;
        this.updateOptions();
        return this;
    }

    public void clearSelection() {
        this.applyFilters = false;
        this.options.select(new String[0]);
        this.applyFilters = true;
    }

    @Override
    public void init() {
        super.init();
        this.options.onSelect(e -> {
            if (!this.applyFilters) {
                return;
            }
            this.collection.filter(this.attribute, e.selection());
        });
    }

    public void refresh() {
        super.refresh();
        this.label.value(this._label + ":");
    }

    private void updateOptions() {
        this.options.clear();
        List groups = this.collection.source().groups(this.attribute);
        groups.forEach(g -> this.options.add(g.label()));
    }
}

