/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.monet.metamodel.SourceDefinition;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Source;
import org.monet.space.kernel.model.Term;
import org.monet.space.kernel.model.TermList;

public class SourceDatasource
extends PageDatasource<Term> {
    private final UnitBox box;
    private final UISession session;
    private final Source<SourceDefinition> source;
    private final Term from;

    public SourceDatasource(UnitBox box, UISession session, Source<SourceDefinition> source, Term from) {
        this.box = box;
        this.session = session;
        this.source = source;
        this.from = from;
    }

    public List<Term> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        DataRequest request = this.request(condition, filters, this.from);
        request.setStartPos(Integer.valueOf(start));
        request.setLimit(Integer.valueOf(count));
        ArrayList<Term> result = new ArrayList<Term>(SourceDatasource.terms(this.source, request, this.box, this.session));
        int from = Math.min(start, result.size());
        int end = Math.min(start + count, result.size());
        return result.subList(from, end);
    }

    public long itemCount(String condition, List<Filter> filters) {
        return SourceDatasource.terms(this.source, this.request(condition, filters, this.from), this.box, this.session).size();
    }

    public List<Group> groups(String key) {
        return Collections.emptyList();
    }

    public static long itemCount(Source<SourceDefinition> source, DataRequest request, UnitBox box, UISession session) {
        return SourceDatasource.terms(source, request, box, session).size();
    }

    private static List<Term> terms(Source<SourceDefinition> source, DataRequest request, UnitBox box, UISession session) {
        boolean onlyEnabled = SourceDatasource.onlyEnabled(request);
        String condition = request.getCondition();
        box.linkSession(session);
        TermList terms = condition == null || condition.isEmpty() ? source.loadTerms(request, onlyEnabled) : source.searchTerms(request);
        return new ArrayList<Term>(terms.get().values());
    }

    private static boolean onlyEnabled(DataRequest request) {
        String mode = request.getParameter("mode");
        return mode == null || !mode.equals("tree");
    }

    private DataRequest request(String condition, List<Filter> filters, Term from) {
        DataRequest request = SourceDatasource.request();
        request.setCondition(condition);
        request.addParameter("mode", "tree");
        request.addParameter("depth", "1");
        if (from != null) {
            request.addParameter("from", from.getCode());
        }
        return request;
    }

    private static DataRequest request() {
        return new DataRequest();
    }
}

