/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.printers;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.printers.Printer;
import io.intino.goros.unit.printers.templates.CsvTaskListTemplate;
import io.intino.goros.unit.printers.templates.PdfTaskListTemplate;
import io.intino.goros.unit.printers.templates.XlsTaskListTemplate;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.monet.space.kernel.library.LibraryDate;
import org.monet.space.kernel.library.LibraryPDF;
import org.monet.space.kernel.model.Account;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.TaskSearchRequest;
import org.monet.space.office.core.model.Language;
import org.monet.space.office.presentation.user.renders.TaskListPrintRender;

public class TaskListPrinter
extends Printer {
    protected final UnitBox box;
    private final Account account;
    private final Map<String, Integer> columnDataSizes = new HashMap<String, Integer>();
    private final Map<String, Integer> columnPercentages = new HashMap<String, Integer>();
    protected final TaskSearchRequest request;
    protected final String format;
    protected final List<String> columns;

    public TaskListPrinter(UnitBox box, Account account, TaskSearchRequest request, String format, List<String> columns) {
        this.box = box;
        this.account = account;
        this.request = request;
        this.format = format;
        this.columns = columns;
    }

    public InputStream print(String language) {
        Template template = this.template();
        String result = template.render((Object)this.build(language).toFrame());
        return new ByteArrayInputStream(this.generateDocument(result));
    }

    protected FrameBuilder build(String language) {
        FrameBuilder result = this.baseFrame().add("tasklist");
        result.add("orientation", (Object)"landscape");
        result.add("label", (Object)this.box.translatorService().translate("Tasks", language));
        result.add("pageLabel", (Object)this.box.translatorService().translate("Page", language));
        result.add("content", (Object)this.contentFrame(language));
        return result;
    }

    private FrameBuilder contentFrame(String language) {
        FrameBuilder result = new FrameBuilder().add("content");
        int count = LayerHelper.taskLayer().searchTasksCount(this.account, this.request);
        this.request.setStartPos(Integer.valueOf(0));
        this.request.setLimit(Integer.valueOf(count));
        result.add("label", (Object)this.box.translatorService().translate("Tasks", language));
        result.add("date", (Object)LibraryDate.getDateAndTimeString((Date)new Date(), (String)Language.getCurrent(), (TimeZone)Language.getCurrentTimeZone(), (String)"text", (Boolean)true, (String)"/"));
        result.add("rowCount", (Object)count);
        if (count <= 0) {
            result.add("empty");
            return result;
        }
        FrameBuilder references = this.referencesFrame(count, language);
        this.calculateColumnPercentages(count, language);
        result.add("references", (Object)references);
        result.add("referencesCount", (Object)this.referencesCount(count));
        result.add("header", (Object)this.headerFrame(language));
        result.add("headerCount", (Object)this.columns.size());
        return result;
    }

    private FrameBuilder headerFrame(String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"header"});
        result.add("reference", (Object)this.referenceFrame(language));
        return result;
    }

    private int referencesCount(int count) {
        return count > 0 ? (this.format.equalsIgnoreCase("xls") ? count + 4 : count) : 0;
    }

    private FrameBuilder referencesFrame(int count, String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"references"});
        this.request.setStartPos(Integer.valueOf(0));
        this.request.setLimit(Integer.valueOf(count));
        Collection tasks = LayerHelper.taskLayer().searchTasks(this.account, this.request).get().values();
        int pos = 0;
        for (Task task : tasks) {
            result.add("reference", (Object)this.referenceFrame(task, pos, language));
            ++pos;
        }
        return result;
    }

    private FrameBuilder referenceFrame(String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"reference"});
        this.columns.forEach(column -> result.add("attribute", (Object)this.attributeFrame((String)column, language)));
        return result;
    }

    private FrameBuilder referenceFrame(Task task, int pos, String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"reference"});
        if (pos % 2 != 0) {
            result.add("odd", (Object)new FrameBuilder(new String[]{"odd"}));
        }
        this.columns.forEach(column -> result.add("attribute", (Object)this.attributeFrame(task, (String)column, language)));
        return result;
    }

    private FrameBuilder attributeFrame(Task task, String column, String language) {
        FrameBuilder result = this.attributeFrame(column, language);
        String value = this.attributeValue(task, column, language).replace("&", "&amp;");
        this.updateColumnDataSize(value, column);
        result.add("value", (Object)(!value.isEmpty() ? value : "-"));
        return result;
    }

    private void calculateColumnPercentages(int numRows, String language) {
        int totalSize = this.getTotalSize();
        if (totalSize == 0) {
            return;
        }
        totalSize = this.fixColumnsWithShortOrLongData(totalSize, language);
        int maxColumnSize = this.maxColumnPercentageWith(this.columns.size());
        for (String column : this.columns) {
            int wordLength = this.wordLength(Language.getInstance().getModelResource((Object)this.attributeLabel(column)));
            int dataSize = this.columnDataSizes.getOrDefault(column, 0);
            if (dataSize > 0 && wordLength > dataSize) {
                dataSize = Math.min(wordLength, maxColumnSize);
            }
            int percentage = dataSize * 100 / totalSize;
            this.columnPercentages.put(column, percentage);
        }
    }

    private int getTotalSize() {
        return this.columnDataSizes.values().stream().mapToInt(v -> v).sum();
    }

    private int fixColumnsWithShortOrLongData(int totalSize, String language) {
        totalSize = this.fixShortDataColumns(totalSize, language);
        totalSize = this.fixLongDataColumns(totalSize, language);
        return totalSize;
    }

    private int fixShortDataColumns(int totalSize, String language) {
        for (String column : this.columns) {
            int wordLength = this.wordLength(Language.getInstance().getModelResource((Object)this.attributeLabel(column))) + 10;
            int dataSize = this.columnDataSizes.getOrDefault(column, 0);
            if (dataSize <= 0 || wordLength <= dataSize) continue;
            this.columnDataSizes.put(column, wordLength);
            totalSize -= dataSize;
            dataSize = wordLength;
            totalSize += dataSize;
        }
        return totalSize;
    }

    private int fixLongDataColumns(int totalSize, String language) {
        int maxColumnSize = this.maxColumnPercentageWith(this.columns.size());
        for (String column : this.columns) {
            int dataSize = this.columnDataSizes.getOrDefault(column, 0);
            if (dataSize * 100 / totalSize <= maxColumnSize) continue;
            int newSize = Math.abs(totalSize * maxColumnSize / 100);
            this.columnDataSizes.put(column, newSize);
            totalSize -= dataSize;
            dataSize = newSize;
            totalSize += dataSize;
        }
        return totalSize;
    }

    @Override
    protected int maxColumnPercentageWith(int countColumns) {
        return 100 / countColumns;
    }

    private void updateColumnDataSize(String value, String column) {
        int size = this.columnDataSizes.getOrDefault(column, 0);
        this.columnDataSizes.put(column, Math.max(value.length(), size));
    }

    private FrameBuilder attributeFrame(String column, String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"attribute", this.attributeType(column).toLowerCase()});
        result.add("label", (Object)this.attributeLabel(column));
        result.add("width", (Object)this.columnPercentages.getOrDefault(column, 0));
        return result;
    }

    private String attributeLabel(String column) {
        String language = Language.getCurrent();
        if (!TaskListPrintRender.attributesLabels.containsKey(language)) {
            language = "es";
        }
        return (String)((List)TaskListPrintRender.attributesLabels.get(language)).get(this.positionOf(column));
    }

    private String attributeType(String column) {
        return (String)TaskListPrintRender.attributesTypes.get(this.positionOf(column));
    }

    private String attributeValue(Task task, String attributeCode, String language) {
        if (attributeCode.equals("label")) {
            return task.getLabel();
        }
        if (attributeCode.equals("description")) {
            return String.format("%s. %s", task.getDefinition().getLabel(), task.getDescription());
        }
        if (attributeCode.equals("createDate")) {
            return LibraryDate.getDateAndTimeString((Date)task.getInternalCreateDate(), (String)Language.getCurrent(), (TimeZone)Language.getCurrentTimeZone(), (String)"numeric", (Boolean)false, (String)"/");
        }
        if (attributeCode.equals("updateDate")) {
            return LibraryDate.getDateAndTimeString((Date)task.getInternalUpdateDate(), (String)Language.getCurrent(), (TimeZone)Language.getCurrentTimeZone(), (String)"numeric", (Boolean)false, (String)"/");
        }
        if (attributeCode.equals("state")) {
            return this.box.translatorService().translate(task.getState(), language);
        }
        if (attributeCode.equals("urgent")) {
            return this.box.translatorService().translate(task.isUrgent() ? "Yes" : "No", language);
        }
        if (attributeCode.equals("owner")) {
            return String.valueOf(task.getOwner() != null ? task.getOwner().getInfo().getFullname() : "-");
        }
        if (attributeCode.equals("comments")) {
            return task.getComments() != null ? task.getComments() : "";
        }
        return "";
    }

    private int positionOf(String attribute) {
        int pos = 0;
        for (String currentAttribute : TaskListPrintRender.attributes) {
            if (currentAttribute.equals(attribute)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    protected FrameBuilder baseFrame() {
        return new FrameBuilder();
    }

    private Template template() {
        if (this.format.equalsIgnoreCase("pdf")) {
            return new PdfTaskListTemplate();
        }
        if (this.format.equalsIgnoreCase("xls")) {
            return new XlsTaskListTemplate();
        }
        return new CsvTaskListTemplate();
    }

    protected byte[] generateDocument(String result) {
        try {
            if (this.format.equalsIgnoreCase("pdf")) {
                return LibraryPDF.create((InputStream)new ByteArrayInputStream(result.getBytes("utf8"))).toByteArray();
            }
            if (this.format.equalsIgnoreCase("xls")) {
                return result.replaceAll("\\\\n", "\r\n").getBytes("UTF-8");
            }
            return result.replaceAll("\\\\n", "\r\n").getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error((Throwable)e);
            return new byte[0];
        }
    }

    private static final class Attribute {
        private static final String Label = "label";
        private static final String Description = "description";
        private static final String CreateDate = "createDate";
        private static final String UpdateDate = "updateDate";
        private static final String State = "state";
        private static final String Urgent = "urgent";
        private static final String Owner = "owner";
        private static final String Comments = "comments";

        private Attribute() {
        }
    }
}

