/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.NewsDatasource;
import io.intino.goros.unit.box.ui.displays.items.NewsListItem;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNewsTemplate;
import io.intino.goros.unit.graph.PostType;
import org.monet.space.kernel.model.news.Post;

public class NewsTemplate
extends AbstractNewsTemplate<UnitBox> {
    public NewsTemplate(UnitBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.newsList.onAddItem(this::refreshPost);
        this.newsList.source((Datasource)new NewsDatasource((UnitBox)this.box(), this.session()));
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.newsList.reload();
    }

    private void refreshPost(AddItemEvent event) {
        Post post = (Post)event.item();
        NewsListItem item = (NewsListItem)event.component();
        item.type.value(this.translate(this.typeOf(post).label()));
        item.title.value(post.getTitle());
        item.title.visible(post.getTarget() == null);
        item.titleLink.title(post.getTitle());
        item.titleLink.visible(post.getTarget() != null);
        item.date.value(post.getInternalCreateDate().toInstant());
        item.body.value(post.getBody());
    }

    private PostType typeOf(Post post) {
        return PostType.from(post.getType());
    }
}

