/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TermDatasource;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.List;
import org.monet.bpi.FieldMultiple;
import org.monet.bpi.FieldSelect;
import org.monet.bpi.types.TermList;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.SelectFieldProperty;
import org.monet.metamodel.SelectFieldPropertyBase;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.components.layers.SourceLayer;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.SerializerData;
import org.monet.space.kernel.model.Term;

public class FieldSelectDatasource
extends TermDatasource {
    private final String source;
    private final SelectFieldProperty definition;

    public FieldSelectDatasource(UnitBox box, UISession session, Node node, FieldMultiple<?, ?> field) {
        this(box, session, node, FieldSelectDatasource.sourceOf(field), (SelectFieldProperty)Dictionary.getInstance().getFieldDefinition(field.getCode()));
    }

    public FieldSelectDatasource(UnitBox box, UISession session, Node node, FieldSelect field) {
        this(box, session, node, field.getSource(), (SelectFieldProperty)field.getDefinition());
    }

    public FieldSelectDatasource(UnitBox box, UISession session, Node node, String source, SelectFieldProperty definition) {
        super(box, session, node);
        this.source = source;
        this.definition = definition;
    }

    @Override
    public List<org.monet.bpi.types.Term> items() {
        TermList result = this.definition.getTerms() != null ? this.loadFromTerms() : this.loadFromSource();
        return this.sorted(result);
    }

    public org.monet.bpi.types.Term item(String key) {
        return this.items().stream().filter(i -> i.getLabel().equals(key)).findFirst().orElse(null);
    }

    private TermList loadFromTerms() {
        return new TermList(this.definition.getTerms().getTermPropertyList());
    }

    private TermList loadFromSource() {
        SourceLayer sourceLayer = LayerHelper.sourceLayer();
        Ref sourceRef = this.definition.getSource();
        String source = this.source != null && !this.source.isEmpty() ? this.source : this.locateSourceIdFromContext(sourceRef.getValue(), this.definition.getSelect());
        String sourceId = this.locateSourceId(sourceRef.getValue(), source);
        TermList result = new TermList();
        if (sourceId != null && !sourceId.isEmpty()) {
            result = this.terms(sourceLayer.loadSourceTerms(sourceLayer.loadSource(sourceId), this.request(), true));
        }
        return result;
    }

    private TermList terms(org.monet.space.kernel.model.TermList monetTermList) {
        TermList result = new TermList();
        monetTermList.forEach(term -> result.add(this.termOf((Term)term)));
        return result;
    }

    private org.monet.bpi.types.Term termOf(Term term) {
        return new org.monet.bpi.types.Term(term.getCode(), this.labelOf(term));
    }

    private String labelOf(Term term) {
        return this.mode().equals("flatten") ? term.getFlattenLabel() : term.getLabel();
    }

    private DataRequest request() {
        SelectFieldPropertyBase.SelectProperty selectDefinition = this.definition.getSelect();
        SelectFieldPropertyBase.SelectProperty.FlattenEnumeration flatten = selectDefinition != null ? selectDefinition.getFlatten() : null;
        Long depth = selectDefinition != null ? selectDefinition.getDepth() : null;
        Object root = selectDefinition != null ? selectDefinition.getRoot() : null;
        DataRequest result = new DataRequest();
        result.setStartPos(Integer.valueOf(0));
        result.setLimit(Integer.valueOf(-1));
        result.addParameter("mode", this.mode());
        result.addParameter("flatten", flatten != null ? flatten.toString() : SelectFieldPropertyBase.SelectProperty.FlattenEnumeration.NONE.toString());
        result.addParameter("depth", depth != null ? String.valueOf(depth) : null);
        result.addParameter("from", this.getSourceFrom(this.node, root));
        result.addParameter("filters", SerializerData.serializeSet(NodeHelper.getFieldFilters(this.node, (FieldProperty)this.definition, false)));
        return result;
    }

    private String mode() {
        SelectFieldPropertyBase.SelectProperty selectDefinition = this.definition.getSelect();
        SelectFieldPropertyBase.SelectProperty.FlattenEnumeration flatten = selectDefinition != null ? selectDefinition.getFlatten() : null;
        return flatten != null && flatten.equals((Object)SelectFieldPropertyBase.SelectProperty.FlattenEnumeration.ALL) ? "flatten" : "tree";
    }

    private static String sourceOf(FieldMultiple<?, ?> field) {
        return field.getCount() > 0 ? ((FieldSelect)field.getAllFields().get(0)).getSource() : null;
    }
}

