/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TermDatasource;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.List;
import org.monet.bpi.FieldCheck;
import org.monet.bpi.types.CheckList;
import org.monet.bpi.types.Term;
import org.monet.bpi.types.TermList;
import org.monet.metamodel.CheckFieldProperty;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.components.layers.SourceLayer;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.SerializerData;

public class FieldCheckDatasource
extends TermDatasource {
    private final FieldCheck field;
    private final CheckFieldProperty definition;

    public FieldCheckDatasource(UnitBox box, UISession session, Node node, FieldCheck field) {
        super(box, session, node);
        this.field = field;
        this.definition = (CheckFieldProperty)((FormDefinition)node.getDefinition()).getField(field.getCode());
    }

    @Override
    public List<Term> items() {
        TermList result = this.definition.getTerms() != null ? this.loadFromTerms() : (this.definition.getSource() != null ? this.loadFromSource() : this.loadFromCheckList());
        return this.sorted(result);
    }

    private TermList loadFromTerms() {
        TermList termList = new TermList(this.definition.getTerms().getTermPropertyList());
        if (termList.getAll().size() == 0) {
            termList = ((CheckList)this.field.get()).toTermList();
        }
        return termList;
    }

    private TermList loadFromSource() {
        SourceLayer sourceLayer = LayerHelper.sourceLayer();
        Ref sourceRef = this.definition.getSource();
        CheckFieldProperty.SelectProperty checkDefinition = this.definition.getSelect();
        String sourceId = this.locateSourceId(sourceRef.getValue(), this.field.getSource());
        TermList result = new TermList();
        String from = this.field.getFrom();
        if (from.isEmpty()) {
            from = this.getSourceFrom(this.node, checkDefinition != null ? checkDefinition.getRoot() : null);
        }
        if (sourceId != null && !sourceId.isEmpty()) {
            result = new TermList(sourceLayer.loadSourceTerms(sourceLayer.loadSource(sourceId), this.request(from), true));
        }
        return result;
    }

    private TermList loadFromCheckList() {
        return ((CheckList)this.field.get()).toTermList();
    }

    private DataRequest request(String from) {
        CheckFieldProperty.SelectProperty selectDefinition = this.definition.getSelect();
        DataRequest result = new DataRequest();
        result.setStartPos(Integer.valueOf(0));
        result.setLimit(Integer.valueOf(-1));
        result.addParameter("mode", selectDefinition != null && selectDefinition.getFlatten() != null && selectDefinition.getFlatten().equals((Object)CheckFieldProperty.SelectProperty.FlattenEnumeration.ALL) ? "flatten" : "tree");
        result.addParameter("flatten", selectDefinition != null && selectDefinition.getFlatten() != null ? selectDefinition.getFlatten().toString() : CheckFieldProperty.SelectProperty.FlattenEnumeration.NONE.toString());
        result.addParameter("depth", selectDefinition != null && selectDefinition.getDepth() != null ? String.valueOf(selectDefinition.getDepth()) : null);
        result.addParameter("from", from);
        result.addParameter("filters", SerializerData.serializeSet(NodeHelper.getFieldFilters(this.node, (FieldProperty)this.definition, false)));
        return result;
    }
}

