import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiSearchBox from "alexandria-ui-elements/src/displays/components/SearchBox";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiCloseDialog from "alexandria-ui-elements/src/displays/components/CloseDialog";
import DisplaysAssignTaskDialogTableRow from "unit-elements/gen/displays/rows/AssignTaskDialogTableRow";
import DisplaysAssignTaskDialogTableFullnameItem from "unit-elements/gen/displays/items/AssignTaskDialogTableFullnameItem";
import DisplaysAssignTaskDialogTableEmailItem from "unit-elements/gen/displays/items/AssignTaskDialogTableEmailItem";
import DisplaysTrashTableRow from "unit-elements/gen/displays/rows/TrashTableRow";
import DisplaysTrashTableTypeItem from "unit-elements/gen/displays/items/TrashTableTypeItem";
import DisplaysTrashTableLabelItem from "unit-elements/gen/displays/items/TrashTableLabelItem";
import DisplaysTrashTableDeleteDateItem from "unit-elements/gen/displays/items/TrashTableDeleteDateItem";
import DisplaysTrashTableOperationsItem from "unit-elements/gen/displays/items/TrashTableOperationsItem";
import DisplaysRolesTableRow from "unit-elements/gen/displays/rows/RolesTableRow";
import DisplaysRolesTableUserItem from "unit-elements/gen/displays/items/RolesTableUserItem";
import DisplaysRolesTableDefinitionItem from "unit-elements/gen/displays/items/RolesTableDefinitionItem";
import DisplaysRolesTableTypeItem from "unit-elements/gen/displays/items/RolesTableTypeItem";
import DisplaysRolesTableNatureItem from "unit-elements/gen/displays/items/RolesTableNatureItem";
import DisplaysRolesTableStartDateItem from "unit-elements/gen/displays/items/RolesTableStartDateItem";
import DisplaysRolesTableEndDateItem from "unit-elements/gen/displays/items/RolesTableEndDateItem";
import DisplaysRolesTableOperationsItem from "unit-elements/gen/displays/items/RolesTableOperationsItem";
import DisplaysAddRoleUserTableRow from "unit-elements/gen/displays/rows/AddRoleUserTableRow";
import DisplaysAddRoleUserTableFullnameItem from "unit-elements/gen/displays/items/AddRoleUserTableFullnameItem";
import DisplaysAddRoleUserTableEmailItem from "unit-elements/gen/displays/items/AddRoleUserTableEmailItem";
import DisplaysAddRoleServiceTableRow from "unit-elements/gen/displays/rows/AddRoleServiceTableRow";
import DisplaysAddRoleServiceTableLabelItem from "unit-elements/gen/displays/items/AddRoleServiceTableLabelItem";
import DisplaysAddRoleServiceTablePartnerItem from "unit-elements/gen/displays/items/AddRoleServiceTablePartnerItem";
import DisplaysAddRoleFeederTableRow from "unit-elements/gen/displays/rows/AddRoleFeederTableRow";
import DisplaysAddRoleFeederTableLabelItem from "unit-elements/gen/displays/items/AddRoleFeederTableLabelItem";
import DisplaysAddRoleFeederTablePartnerItem from "unit-elements/gen/displays/items/AddRoleFeederTablePartnerItem";
import DisplaysLinksInTableRow from "unit-elements/gen/displays/rows/LinksInTableRow";
import DisplaysLinksInTableLabelItem from "unit-elements/gen/displays/items/LinksInTableLabelItem";
import DisplaysLinksInTableDescriptionItem from "unit-elements/gen/displays/items/LinksInTableDescriptionItem";
import DisplaysLinksOutTableRow from "unit-elements/gen/displays/rows/LinksOutTableRow";
import DisplaysLinksOutTableLabelItem from "unit-elements/gen/displays/items/LinksOutTableLabelItem";
import DisplaysLinksOutTableDescriptionItem from "unit-elements/gen/displays/items/LinksOutTableDescriptionItem";
import DisplaysNodeRevisionsTableRow from "unit-elements/gen/displays/rows/NodeRevisionsTableRow";
import DisplaysNodeRevisionsTableLabelItem from "unit-elements/gen/displays/items/NodeRevisionsTableLabelItem";
import DisplaysNodeRevisionsTableOperationsItem from "unit-elements/gen/displays/items/NodeRevisionsTableOperationsItem";
import DisplaysNodeNotesTableRow from "unit-elements/gen/displays/rows/NodeNotesTableRow";
import DisplaysNodeNotesTableNameItem from "unit-elements/gen/displays/items/NodeNotesTableNameItem";
import DisplaysNodeNotesTableValueItem from "unit-elements/gen/displays/items/NodeNotesTableValueItem";
import DisplaysNodeNotesTableOperationsItem from "unit-elements/gen/displays/items/NodeNotesTableOperationsItem";
import DisplaysTasksTableRow from "unit-elements/gen/displays/rows/TasksTableRow";
import DisplaysTasksTableLabelItem from "unit-elements/gen/displays/items/TasksTableLabelItem";
import DisplaysTasksTableOwnerItem from "unit-elements/gen/displays/items/TasksTableOwnerItem";
import DisplaysTasksTableCreateDateItem from "unit-elements/gen/displays/items/TasksTableCreateDateItem";
import DisplaysTasksTableUpdateDateItem from "unit-elements/gen/displays/items/TasksTableUpdateDateItem";
import DisplaysTasksTableCountMessagesItem from "unit-elements/gen/displays/items/TasksTableCountMessagesItem";
import DisplaysTasksTableOperationsItem from "unit-elements/gen/displays/items/TasksTableOperationsItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TaskToolbarTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TaskToolbarTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TaskToolbarTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TaskToolbarTemplateNotifier(this);
		this.requester = new TaskToolbarTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2145557358" layout="vertical centerjustified flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2145557358.a1495624939" layout="horizontal">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2145557358.a1495624939.a1898418071" title="Actualizar" target="self" mode="Button" size="Small" format="airRight" highlighted="Outline">
						</UiAction>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2145557358.a1495624939.a1329059773" title="Asignar..." target="self" mode="Button" size="Small" format="airRight" highlighted="Outline" visible={false}>
						</UiOpenDialog>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2145557358.a1495624939.a553205814" title="Desasignar" target="self" mode="Button" affirmed="Are you sure to unassign task?" size="Small" format="airRight" highlighted="Outline" visible={false}>
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2145557358.a1495624939.a735099554" title="Abortar" target="self" mode="Button" affirmed="Are you sure to abort task?" size="Small" highlighted="Outline" visible={false}>
						</UiAction>
					</UiBlock>
				</UiBlock>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738" title="Asignar..." width="80.0%" height="80.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852" layout="vertical flexible" width="100.0%" height="calc(100% - 50px)">
						<UiSearchBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_89851308" showCountMessage="true">
						</UiSearchBox>
						<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441" format="bordered" noItemsMessage="No hay usuarios" pageSize={20} itemHeight={30} scrollingMark={false} selection="single">
							<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a1414570240" style={{width:"16%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a1414570240.a_684437777" mode="normal" translate={true} value="Fullname">
								</UiText>
							</UiHeading>
							<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a_463753242" style={{width:"16%",paddingRight:"10px"}} hidden="Never">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a_463753242.a_433397181" mode="normal" translate={true} value="Email">
								</UiText>
							</UiHeading>
						</UiTable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1485711337" label="Reason" format="doubleAirTop doubleAirBottom greyBackground" mode="normal" editionMode="Raw" rows={5} placeholder="">
						</UiTextEditable>
					</UiBlock>
					<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_1591850339">
					</UiDivider>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_1962087451" layout="horizontal endjustified">
						<UiCloseDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_1962087451.a_689589559" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
						</UiCloseDialog>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_1962087451.a_745326249" title="OK" target="self" mode="Button" readonly={true} size="Medium" highlighted="Fill">
						</UiAction>
					</UiBlock>
				</UiDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TaskToolbarTemplate));
DisplayFactory.register("TaskToolbarTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TaskToolbarTemplate)));