/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.DisplayProvider;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskPlaceDelegationTemplate;
import io.intino.goros.unit.box.ui.displays.templates.TaskPlaceRoleTemplate;
import io.intino.goros.unit.util.AccountHelper;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.RoleHelper;
import org.monet.bpi.java.FieldBooleanImpl;
import org.monet.bpi.java.FieldDateImpl;
import org.monet.bpi.java.FieldTextImpl;
import org.monet.bpi.types.Date;
import org.monet.metamodel.DelegationActionProperty;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.PlaceActionProperty;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.RoleDefinition;
import org.monet.metamodel.TaskProviderProperty;
import org.monet.space.kernel.machines.ttm.behavior.ProviderBehavior;
import org.monet.space.kernel.model.Attribute;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.Role;
import org.monet.space.kernel.model.RoleList;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.TaskOrder;

public class TaskPlaceDelegationTemplate
extends AbstractTaskPlaceDelegationTemplate<UnitBox> {
    private Task task;
    private DelegationActionProperty property;
    private DisplayProvider displayProvider;

    public TaskPlaceDelegationTemplate(UnitBox box) {
        super(box);
    }

    public TaskPlaceDelegationTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskPlaceDelegationTemplate property(DelegationActionProperty property) {
        this.property = property;
        return this;
    }

    public TaskPlaceDelegationTemplate displayProvider(DisplayProvider provider) {
        this.displayProvider = provider;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.waitingView.onShow(e -> this.refreshWaitingView());
        this.pendingView.onShow(e -> {
            this.pendingView.setupBlock.setupToolbar.solveSetup.onExecute(e1 -> this.setup());
            this.refreshPendingView();
        });
        this.failureView.onShow(e -> {
            this.failureView.tryingView.retry.onExecute(e1 -> this.retry());
            this.refreshFailureView();
        });
    }

    public void refresh() {
        super.refresh();
        this.label.value(Language.getInstance().getModelResource(this.property.getLabel()));
        this.waitingView.visible(this.task.isWaiting());
        this.pendingView.visible(this.task.isPending());
        this.failureView.visible(this.task.isFailure());
        this.refreshView();
    }

    private void refreshView() {
        if (this.pendingView.isVisible()) {
            this.refreshPendingView();
        } else if (this.waitingView.isVisible()) {
            this.refreshWaitingView();
        } else if (this.failureView.isVisible()) {
            this.refreshFailureView();
        }
    }

    private void refreshWaitingView() {
        if (!this.task.isWaiting()) {
            return;
        }
    }

    private void refreshPendingView() {
        if (!this.task.isPending()) {
            return;
        }
        if (this.property.getMode() != null && this.property.getMode() == DelegationActionProperty.ModeEnumeration.AUTOMATIC) {
            return;
        }
        Role.Nature nature = this.nature();
        TaskOrder order = this.order();
        this.refreshSelectRoleStep(order, nature);
        this.refreshSetupStep(order);
    }

    private void refreshSelectRoleStep(TaskOrder order, Role.Nature nature) {
        if (order != null && order.getRole() != null) {
            return;
        }
        if (nature == null) {
            this.pendingView.pendingMessage.value(this.translate("No external/internal provider defined. Contact with administrator"));
            return;
        }
        RoleList roleList = this.roles(nature);
        this.pendingView.openRoles.visible(roleList.getTotalCount() <= 0);
        this.pendingView.openRoles.address(path -> "/permisos");
        this.pendingView.openRoles.readonly(!RoleHelper.canAccessRoles(this.session()));
        this.pendingView.setupBlock.visible(false);
        if (roleList.getTotalCount() <= 0) {
            RoleDefinition roleDefinition = this.roleDefinition(this.providerDefinition());
            String label = Language.getInstance().getModelResource(roleDefinition.getLabel());
            this.pendingView.pendingMessage.value(this.translate("No roles of type ::role:: defined for delegation").replace("::role::", label));
            return;
        }
        this.pendingView.pendingMessage.value(this.translate("Select client to whom send order:"));
        this.pendingView.roles.clear();
        roleList.get().values().forEach(role -> this.fill((Role)role, (TaskPlaceRoleTemplate)this.pendingView.roles.add()));
    }

    private void refreshFailureView() {
        if (!this.task.isFailure()) {
            return;
        }
        java.util.Date date = this.task.getProcess().getCurrentProvider().getModel().getFailureDate();
        this.failureView.lastSendingView.visible(date != null);
        this.failureView.tryingView.visible(date == null);
        if (date != null) {
            this.failureDate.value(date.toInstant());
        }
    }

    private void refreshSetupStep(TaskOrder order) {
        if (order == null || order.getRole() == null || order.getSetupNodeId() == null) {
            return;
        }
        Node setupNode = this.setupNode(order);
        Role role = order.getRole();
        this.pendingView.setupBlock.visible(true);
        this.pendingView.openRoles.visible(false);
        if (setupNode == null) {
            this.pendingView.pendingMessage.value(this.translate("Sending order..."));
        } else {
            this.pendingView.pendingMessage.value(this.translate("Setup order for ::role::").replace("::role::", role.getLabel()));
            this.refreshSetupForm(setupNode);
        }
    }

    private void refreshSetupForm(Node form) {
        this.pendingView.setupBlock.setupFrame.clear();
        if (form == null) {
            return;
        }
        NodeViewProperty viewProperty = DisplayHelper.defaultEmbeddedView(form);
        Display display = this.displayProvider.displayFor(form, viewProperty != null ? viewProperty.getCode() : null);
        if (display == null) {
            return;
        }
        this.pendingView.setupBlock.setupFrame.display(display);
        display.refresh();
    }

    private void fill(Role role, TaskPlaceRoleTemplate view) {
        view.role(role);
        view.confirmText(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        view.onSelect(e -> this.select(role));
        view.refresh();
    }

    private void select(Role role) {
        this.task.getProcess().selectDelegationActionRole(role);
    }

    private void setup() {
        this.notifyUser(this.translate("Setting up delegation..."), UserMessage.Type.Loading);
        this.solveSetup.readonly(true);
        this.fillOrder();
        this.task.getProcess().setupDelegationAction();
        this.solveSetup.readonly(false);
        this.notifyUser(this.translate("Delegation setup"), UserMessage.Type.Success);
    }

    private void fillOrder() {
        TaskOrder order = this.order();
        if (order == null) {
            return;
        }
        Node setupNode = this.setupNode(order);
        if (setupNode == null) {
            return;
        }
        Date startDate = FieldDateImpl.get((Attribute)setupNode.getAttribute("_vrwtkw"));
        Date endDate = FieldDateImpl.get((Attribute)setupNode.getAttribute("_7vewhg"));
        order.setSuggestedStartDate(startDate != null ? startDate.getValue() : null);
        order.setSuggestedEndDate(endDate != null ? endDate.getValue() : null);
        order.setComments(FieldTextImpl.get((Attribute)setupNode.getAttribute("_y__kmq")));
        order.setUrgent(FieldBooleanImpl.get((Attribute)setupNode.getAttribute("_ss7omw")).booleanValue());
        LayerHelper.taskLayer().saveTaskOrder(order);
    }

    private TaskOrder order() {
        ProviderBehavior currentProvider = this.task.getProcess().getCurrentProvider();
        String orderId = currentProvider != null ? currentProvider.getModel().getOrderId() : null;
        return orderId != null ? LayerHelper.taskLayer().loadTaskOrder(orderId) : null;
    }

    private Node setupNode(TaskOrder order) {
        return order.getSetupNodeId() != null ? LayerHelper.nodeLayer().loadNode(order.getSetupNodeId()) : null;
    }

    private Role.Nature nature() {
        TaskProviderProperty providerDefinition = this.providerDefinition();
        if (providerDefinition.getExternal() != null && providerDefinition.getInternal() != null) {
            return Role.Nature.Both;
        }
        if (providerDefinition.getExternal() != null) {
            return Role.Nature.External;
        }
        if (providerDefinition.getInternal() != null) {
            return Role.Nature.Internal;
        }
        return null;
    }

    private RoleList roles(Role.Nature nature) {
        TaskProviderProperty providerDefinition = this.providerDefinition();
        RoleDefinition roleDefinition = this.roleDefinition(providerDefinition);
        return AccountHelper.loadNonExpiredRoleList(roleDefinition.getCode(), nature);
    }

    private TaskProviderProperty providerDefinition() {
        ProcessDefinition definition = (ProcessDefinition)this.task.getDefinition();
        String providerKey = this.property.getProvider().getValue();
        return (TaskProviderProperty)definition.getTaskProviderPropertyMap().get(providerKey);
    }

    private RoleDefinition roleDefinition(TaskProviderProperty providerDefinition) {
        String roleKey = providerDefinition.getRole().getValue();
        return Dictionary.getInstance().getRoleDefinition(roleKey);
    }

    private void retry() {
        this.failureView.tryingView.retry.readonly(true);
        this.task.getProcess().resume();
        this.failureView.tryingView.retry.readonly(false);
    }
}

