/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Layer;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskHistoryEntryLinkTemplate;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.PathHelper;
import java.util.function.BiConsumer;
import org.monet.space.kernel.model.MonetLink;
import org.monet.space.kernel.model.Node;

public class TaskHistoryEntryLinkTemplate
extends AbstractTaskHistoryEntryLinkTemplate<UnitBox> {
    private MonetLink monetLink;
    private BiConsumer<String, Layer<?, ?>> openLayerListener;

    public TaskHistoryEntryLinkTemplate(UnitBox box) {
        super(box);
    }

    public TaskHistoryEntryLinkTemplate monetLink(MonetLink link) {
        this.monetLink = link;
        return this;
    }

    public TaskHistoryEntryLinkTemplate onOpenLayer(BiConsumer<String, Layer<?, ?>> listener) {
        this.openLayerListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.link.onOpen(e -> this.openLayerListener.accept(this.monetLink.getLabel(), e.layer()));
        this.documentDialog.onOpen(e -> this.refreshDocumentDialog());
    }

    public void refresh() {
        super.refresh();
        boolean isDocument = this.isDocument();
        this.documentLink.title(this.monetLink.getLabel());
        this.documentLink.visible(isDocument);
        this.link.title(this.monetLink.getLabel());
        this.link.address(path -> PathHelper.pathOf(this.monetLink));
        this.link.visible(!isDocument);
    }

    private void refreshDocumentDialog() {
        this.documentDialog.title(this.monetLink.getLabel());
        this.documentDialog.documentStamp.node(this.node());
        this.documentDialog.documentStamp.readonly(true);
        this.documentDialog.documentStamp.refresh();
    }

    private boolean isDocument() {
        if (this.monetLink.getType() != MonetLink.Type.Node) {
            return false;
        }
        return this.node().isDocument();
    }

    private Node node() {
        return LayerHelper.nodeLayer().loadNode(this.monetLink.getId());
    }
}

