/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractSourceTermTagTemplate;
import java.util.function.BiConsumer;

public class SourceTermTagTemplate
extends AbstractSourceTermTagTemplate<UnitBox> {
    private String _name;
    private String _value;
    private BiConsumer<String, String> changeListener;
    private BiConsumer<String, String> deleteListener;

    public SourceTermTagTemplate(UnitBox box) {
        super(box);
    }

    public SourceTermTagTemplate name(String tag) {
        this._name = tag;
        return this;
    }

    public SourceTermTagTemplate value(String value) {
        this._value = value;
        return this;
    }

    public SourceTermTagTemplate onChange(BiConsumer<String, String> listener) {
        this.changeListener = listener;
        return this;
    }

    public SourceTermTagTemplate onDelete(BiConsumer<String, String> listener) {
        this.deleteListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.name.onChange(e -> {
            String value = (String)e.value();
            if (value.isEmpty()) {
                this.name.value(this._name);
                this.notifyUser(this.translate("Name cannot be empty"), UserMessage.Type.Error);
                return;
            }
            this.notifyChange();
        });
        this.value.onChange(e -> this.notifyChange());
        this.delete.onExecute(e -> this.notifyDelete());
    }

    public void refresh() {
        super.refresh();
        this.name.value(this._name);
        this.value.value(this._value);
    }

    private void notifyChange() {
        this.changeListener.accept(this.name.value(), this.value.value());
    }

    private void notifyDelete() {
        this.deleteListener.accept(this.name.value(), this.value.value());
    }
}

