/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.utils.DelayerUtil;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.SourceDatasource;
import io.intino.goros.unit.box.ui.displays.items.SourceLevelListItem;
import io.intino.goros.unit.box.ui.displays.templates.AbstractSourceLevelTemplate;
import io.intino.goros.unit.util.SourceHelper;
import java.util.List;
import java.util.function.BiConsumer;
import org.monet.metamodel.SourceDefinition;
import org.monet.space.kernel.model.Source;
import org.monet.space.kernel.model.Term;

public class SourceLevelTemplate
extends AbstractSourceLevelTemplate<UnitBox> {
    private Source<SourceDefinition> source;
    private Term term;
    private Term termSelected = null;
    private BiConsumer<Term, Integer> selectListener;
    private int level = -1;

    public SourceLevelTemplate(UnitBox box) {
        super(box);
    }

    public SourceLevelTemplate source(Source<SourceDefinition> source) {
        this.source = source;
        if (this.sourceLevelList != null) {
            this.sourceLevelList.source(null);
        }
        return this;
    }

    public SourceLevelTemplate term(Term term) {
        this.term = term;
        if (this.sourceLevelList != null) {
            this.sourceLevelList.source(null);
        }
        return this;
    }

    public int level() {
        return this.level;
    }

    public SourceLevelTemplate level(int level) {
        this.level = level;
        return this;
    }

    public SourceLevelTemplate onSelect(BiConsumer<Term, Integer> listener) {
        this.selectListener = listener;
        return this;
    }

    public void selectDelayed(Term term) {
        DelayerUtil.execute((Display)this, e -> this.select(term), (int)300);
    }

    private void select(Term term) {
        this.sourceLevelList.select(this.sourceLevelList.findItem(i -> ((Term)i).getCode().equals(term.getCode())));
    }

    @Override
    public void init() {
        super.init();
        this.sourceLevelList.onSelect(e -> this.selectTerm(e.selection()));
        this.sourceLevelList.onAddItem(e -> {
            Term term = (Term)e.item();
            SourceLevelListItem item = (SourceLevelListItem)e.component();
            item.disabledLayer.visible(!term.isEnabled());
            item.label.value(term.getLabel());
            item.code.value(term.getCode());
            item.type.value(this.translate(SourceHelper.typeLabel(term)));
            item.type.backgroundColor(SourceHelper.typeColor(term));
            item.tagsCount.value(term.getTags().size());
            item.groupFlag.visible(term.isCategory() || term.isSuperTerm());
        });
    }

    private void selectTerm(List<Term> selection) {
        Term selected;
        if (this.selectListener == null) {
            return;
        }
        Term term = selected = selection.size() > 0 ? selection.get(0) : null;
        if (selected == null && this.termSelected != null && this.termSelected.getParent() != null) {
            this.selectDelayed(this.termSelected);
        } else {
            this.selectListener.accept(selected, this.level);
        }
        this.termSelected = selected;
    }

    public long childrenCount() {
        return this.sourceLevelList.source() != null ? this.sourceLevelList.itemCount() : 0L;
    }

    public void refresh() {
        super.refresh();
        if (this.sourceLevelList.source() == null) {
            this.sourceLevelList.source((Datasource)new SourceDatasource((UnitBox)this.box(), this.session(), this.source, this.term));
        }
        this.sourceLevelList.reload();
    }

    public void refresh(Term term) {
        this.sourceLevelList.refresh(this.sourceLevelList.findItem(t -> ((Term)t).getCode().equals(term.getCode())), term);
    }
}

