/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractSourceEmbeddedTemplate;
import io.intino.goros.unit.box.ui.displays.templates.SourceLevelTemplate;
import io.intino.goros.unit.util.LayerHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.monet.metamodel.SourceDefinition;
import org.monet.space.kernel.model.Source;
import org.monet.space.kernel.model.Term;

public class SourceEmbeddedTemplate
extends AbstractSourceEmbeddedTemplate<UnitBox> {
    private Source<SourceDefinition> source;
    private Consumer<Long> termsCountListener;
    private int currentLevel = 0;
    private Map<Integer, Term> selectedTerms = new HashMap<Integer, Term>();
    private int selectedLevel = 0;

    public SourceEmbeddedTemplate(UnitBox box) {
        super(box);
    }

    public SourceEmbeddedTemplate source(Source<SourceDefinition> source) {
        this.source = source;
        return this;
    }

    public SourceEmbeddedTemplate onTermsCountChange(Consumer<Long> listener) {
        this.termsCountListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.termView.onInit(e -> {
            this.termView.termDialog.onTermAdded(term -> {
                Term parent = this.termView.termDialog.term();
                SourceLevelTemplate view = this.addOrGet(parent != null ? this.selectedLevel + 1 : this.selectedLevel);
                if (parent != null) {
                    view.term(parent);
                }
                view.refresh();
                view.selectDelayed((Term)term);
                this.save((Term)term, this.source);
                this.refreshPublishTermsDialog();
            });
            this.termView.termDialog.onTermModified(term -> {
                this.addOrGet(this.selectedLevel).refresh((Term)term);
                if (term.isTerm()) {
                    this.hideLevels(this.selectedLevel + 1);
                } else {
                    this.showLevel(this.selectedLevel + 1, (Term)term);
                }
                this.save((Term)term, this.source);
            });
            this.termView.termDialog.onTermDeleted(term -> {
                this.refreshAfterDeleting();
                this.save((Term)term, this.source);
            });
        });
        this.termView.onShow(e -> {
            Term selected = this.selectedTerms.getOrDefault(this.selectedLevel, null);
            this.refreshCount(selected != null && selected.isTerm() ? 0L : this.addOrGet(selected != null ? this.selectedLevel + 1 : this.selectedLevel).childrenCount());
            this.refreshPublishTermsDialog();
            this.refreshTermDialog();
        });
    }

    private void refreshAfterDeleting() {
        this.refreshPublishTermsDialog();
        this.addOrGet(this.selectedLevel).refresh();
        --this.selectedLevel;
        this.refreshTermDialog();
    }

    public void refresh() {
        super.refresh();
        this.resetLevels();
        this.termView.show();
    }

    private void resetLevels() {
        this.levels.clear();
        this.addLevel();
    }

    private void addLevel() {
        this.addLevel(null, 0);
    }

    private void addLevel(Term term, int level) {
        SourceLevelTemplate view = this.addOrGet(level);
        view.source(this.source);
        view.term(term);
        view.level(level);
        view.onSelect(this::select);
        view.show();
        view.refresh();
        this.currentLevel = level + 1;
    }

    private SourceLevelTemplate addOrGet(int level) {
        List children = this.levels.children(SourceLevelTemplate.class);
        int size = children.size();
        return level < size ? (SourceLevelTemplate)((Object)children.get(level)) : ((SourceLevelTemplate)this.levels.add()).source(this.source);
    }

    private void select(Term term, int level) {
        Term parent = this.selectedTerms.getOrDefault(level - 1, null);
        this.hideLevels(level + 1);
        if (term == null && parent != null) {
            this.select(parent, level - 1);
            return;
        }
        if (term != null && !term.isTerm()) {
            this.addLevel(term, level + 1);
        }
        this.selectedTerms.put(level, term);
        this.selectedLevel = level;
        this.termView.show();
    }

    private void refreshCount(long count) {
        if (this.termsCountListener != null) {
            this.termsCountListener.accept(count);
        }
    }

    private void hideLevels(int level) {
        List children = this.levels.children(SourceLevelTemplate.class);
        for (SourceLevelTemplate child : children) {
            if (child.level() < level) continue;
            child.hide();
        }
    }

    private void showLevel(int level, Term term) {
        List children = this.levels.children(SourceLevelTemplate.class);
        for (SourceLevelTemplate child : children) {
            if (child.level() != level) continue;
            child.show();
            child.term(term);
            child.refresh();
        }
    }

    private void save(Term term, Source<SourceDefinition> source) {
        source.setUpdateDate(new Date());
        LayerHelper.sourceLayer().saveSource(source);
    }

    private void refreshPublishTermsDialog() {
        int count = LayerHelper.sourceLayer().loadSourceNewTerms(this.source).getCount();
        this.termView.publishTermsDialog.source(this.source);
        this.termView.publishTermsDialog.onPublish(e -> this.refreshPublishTermsDialog());
        this.termView.publishTermsDialog.onDelete(e -> this.refreshAfterDeleting());
        this.termView.publishTermsDialog.visible(count > 0);
        if (count <= 0) {
            return;
        }
        this.termView.publishTermsDialog.refresh();
    }

    private void refreshTermDialog() {
        this.termView.termDialog.source(this.source);
        this.termView.termDialog.term(this.selectedTerms.getOrDefault(this.selectedLevel, null));
        this.termView.termDialog.refresh();
    }
}

