/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.NodeNotesDatasource;
import io.intino.goros.unit.box.ui.datasources.model.Note;
import io.intino.goros.unit.box.ui.displays.rows.NodeNotesTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeNotesTemplate;
import io.intino.goros.unit.util.DictionaryHelper;
import io.intino.goros.unit.util.LayerHelper;
import org.monet.metamodel.NodeViewProperty;
import org.monet.space.kernel.model.Node;

public class NodeNotesTemplate
extends AbstractNodeNotesTemplate<UnitBox> {
    private Node node;
    private NodeViewProperty view;
    private boolean readonly = true;

    public NodeNotesTemplate(UnitBox box) {
        super(box);
    }

    public NodeNotesTemplate node(Node node) {
        this.node = node;
        return this;
    }

    public NodeNotesTemplate view(String view) {
        this.view = view != null ? DictionaryHelper.view(this.node, view) : null;
        return this;
    }

    public NodeNotesTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initDialog();
        this.nodeNotesTable.onAddItem(e -> {
            Note note = (Note)e.item();
            NodeNotesTableRow row = (NodeNotesTableRow)e.component();
            row.nodeNotesTableNameItem.name.value(note.name());
            row.nodeNotesTableValueItem.value.value(note.value());
            row.nodeNotesTableOperationsItem.remove.readonly(this.readonly);
            row.nodeNotesTableOperationsItem.remove.onExecute(e1 -> this.removeNote(note));
        });
    }

    public void refresh() {
        super.refresh();
        this.nodeNotesTable.source((Datasource)new NodeNotesDatasource((UnitBox)this.box(), this.session(), this.node, this.view));
        this.nodeNotesTable.reload();
        this.nodeNotesDialog.visible(!this.readonly);
    }

    private void initDialog() {
        this.valueField.onEnterPress(e -> this.addNote());
        this.add.onExecute(e -> this.addNote());
    }

    private void addNote() {
        String name = this.nameField.value();
        String value = this.valueField.value();
        if (name == null || name.isEmpty()) {
            this.notifyUser("Para poder a\u00f1adir una nota, debe indicar al menos un nombre", UserMessage.Type.Error);
            return;
        }
        this.node.addNote(name, value);
        LayerHelper.nodeLayer().saveNodeNotes(this.node);
        this.refresh();
    }

    private void removeNote(Note note) {
        this.node.deleteNote(note.name());
        LayerHelper.nodeLayer().saveNodeNotes(this.node);
        this.refresh();
    }
}

