/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskFolderGrouping;
import io.intino.goros.unit.box.ui.displays.templates.AbstractComboFilterTemplate;
import java.util.List;

public class ComboFilterTemplate
extends AbstractComboFilterTemplate<UnitBox> {
    private String _label;
    private String attribute;
    private Collection collection;
    private boolean applyFilters = true;

    public ComboFilterTemplate(UnitBox box) {
        super(box);
    }

    public ComboFilterTemplate label(String label) {
        this._label = label;
        return this;
    }

    public ComboFilterTemplate attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public ComboFilterTemplate bindTo(Collection collection) {
        this.collection = collection;
        this.updateOptions();
        return this;
    }

    public void multipleSelection(boolean value) {
        this.options.multipleSelection(value);
    }

    public void clearSelection() {
        this.applyFilters = false;
        this.options.select(new String[0]);
        this.applyFilters = true;
    }

    public void select(TaskFolderGrouping folder) {
        this.applyFilters = false;
        this.options.select(new String[]{folder.title()});
        this.applyFilters = true;
    }

    @Override
    public void init() {
        super.init();
        this.options.onSelect(e -> {
            if (!this.applyFilters) {
                return;
            }
            this.collection.filter(this.attribute, e.selection());
        });
    }

    public void refresh() {
        super.refresh();
        this.label.value(this._label + ":");
    }

    private void updateOptions() {
        this.options.clear();
        List groups = this.collection.source().groups(this.attribute);
        groups.forEach(g -> this.options.add(g.label()));
    }
}

