/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TermDatasource;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.monet.bpi.FieldMultiple;
import org.monet.bpi.FieldSelect;
import org.monet.bpi.types.Term;
import org.monet.bpi.types.TermList;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.SelectFieldProperty;
import org.monet.metamodel.SelectFieldPropertyBase;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.components.layers.SourceLayer;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.SerializerData;

public class FieldSelectDatasource
extends TermDatasource {
    private final String source;
    private final SelectFieldProperty definition;

    public FieldSelectDatasource(UnitBox box, UISession session, Node node, FieldMultiple<?, ?> field) {
        this(box, session, node, FieldSelectDatasource.sourceOf(field), (SelectFieldProperty)Dictionary.getInstance().getFieldDefinition(field.getCode()));
    }

    public FieldSelectDatasource(UnitBox box, UISession session, Node node, FieldSelect field) {
        this(box, session, node, field.getSource(), (SelectFieldProperty)field.getDefinition());
    }

    public FieldSelectDatasource(UnitBox box, UISession session, Node node, String source, SelectFieldProperty definition) {
        super(box, session, node);
        this.source = source;
        this.definition = definition;
    }

    @Override
    public List<Term> items() {
        Collection<Term> result = this.definition.getTerms() != null ? this.loadFromTerms() : this.loadFromSource();
        return new ArrayList<Term>(result);
    }

    public Term item(String key) {
        return this.items().stream().filter(i -> i.getLabel().equals(key)).findFirst().orElse(null);
    }

    private Collection<Term> loadFromTerms() {
        return new TermList(this.definition.getTerms().getTermPropertyList()).getAll();
    }

    private Collection<Term> loadFromSource() {
        SourceLayer sourceLayer = LayerHelper.sourceLayer();
        Ref sourceRef = this.definition.getSource();
        String source = this.source != null && !this.source.isEmpty() ? this.source : this.locateSourceIdFromContext(sourceRef.getValue(), this.definition.getSelect());
        String sourceId = this.locateSourceId(sourceRef.getValue(), source);
        TermList result = new TermList();
        if (sourceId != null && !sourceId.isEmpty()) {
            result = new TermList(sourceLayer.loadSourceTerms(sourceLayer.loadSource(sourceId), this.request(), true));
        }
        return result.getAll();
    }

    private DataRequest request() {
        SelectFieldPropertyBase.SelectProperty selectDefinition = this.definition.getSelect();
        SelectFieldPropertyBase.SelectProperty.FlattenEnumeration flatten = selectDefinition != null ? selectDefinition.getFlatten() : null;
        Long depth = selectDefinition != null ? selectDefinition.getDepth() : null;
        Object root = selectDefinition != null ? selectDefinition.getRoot() : null;
        DataRequest result = new DataRequest();
        result.addParameter("mode", flatten != null && flatten.equals((Object)SelectFieldPropertyBase.SelectProperty.FlattenEnumeration.ALL) ? "flatten" : "tree");
        result.addParameter("flatten", flatten != null ? flatten.toString() : SelectFieldPropertyBase.SelectProperty.FlattenEnumeration.NONE.toString());
        result.addParameter("depth", depth != null ? String.valueOf(depth) : null);
        result.addParameter("from", this.getSourceFrom(this.node, root));
        result.addParameter("filters", SerializerData.serializeSet(NodeHelper.getFieldFilters(this.node, (FieldProperty)this.definition, false)));
        return result;
    }

    private static String sourceOf(FieldMultiple<?, ?> field) {
        return field.getCount() > 0 ? ((FieldSelect)field.getAllFields().get(0)).getSource() : null;
    }
}

