package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class BackServiceService {

	public static AlexandriaSpark setup(AlexandriaSpark server, UnitBox box) {
		server.route("backservice/adddatastorecubefact").post(manager -> new PostAddDatastoreCubeFactResource(box, manager).execute());
		server.route("backservice/adddatastorecubefacts").post(manager -> new PostAddDatastoreCubeFactsResource(box, manager).execute());
		server.route("backservice/adddatastoredimensioncomponent").post(manager -> new PostAddDatastoreDimensionComponentResource(box, manager).execute());
		server.route("backservice/addnodeflag").post(manager -> new PostAddNodeFlagResource(box, manager).execute());
		server.route("backservice/addnodenote").post(manager -> new PostAddNodeNoteResource(box, manager).execute());
		server.route("backservice/addsourceterm").post(manager -> new PostAddSourceTermResource(box, manager).execute());
		server.route("backservice/addtaskflact").post(manager -> new PostAddTaskFactResource(box, manager).execute());
		server.route("backservice/addtaskflag").post(manager -> new PostAddTaskFlagResource(box, manager).execute());
		server.route("backservice/addtaskshortcut").post(manager -> new PostAddTaskShortcutResource(box, manager).execute());
		server.route("backservice/consolidatenode").post(manager -> new PostConsolidateNodeResource(box, manager).execute());
		server.route("backservice/createaccount").post(manager -> new PostCreateAccountResource(box, manager).execute());
		server.route("backservice/createnode").post(manager -> new PostCreateNodeResource(box, manager).execute());
		server.route("backservice/createtask").post(manager -> new PostCreateTaskResource(box, manager).execute());
		server.route("backservice/deletenodeflag").post(manager -> new PostDeleteNodeFlagResource(box, manager).execute());
		server.route("backservice/deletenodenote").post(manager -> new PostDeleteNodeNoteResource(box, manager).execute());
		server.route("backservice/createtaskflag").post(manager -> new PostDeleteTaskFlagResource(box, manager).execute());
		server.route("backservice/deletetaskshortcut").post(manager -> new PostDeleteTaskShortcutResource(box, manager).execute());
		server.route("backservice/downloaddistribution").post(manager -> new PostDownloadDistributionResource(box, manager).execute());
		server.route("backservice/emptytrash").post(manager -> new PostEmptyTrashResource(box, manager).execute());
		server.route("backservice/executeexporter").post(manager -> new PostExecuteExporterResource(box, manager).execute());
		server.route("backservice/executenodecommand").post(manager -> new PostExecuteNodeCommandResource(box, manager).execute());
		server.route("backservice/existsnode").post(manager -> new PostExistsNodeResource(box, manager).execute());
		server.route("backservice/exportnode").post(manager -> new PostExportNodeResource(box, manager).execute());
		server.route("backservice/exportnodes").post(manager -> new PostExportNodesResource(box, manager).execute());
		server.route("backservice/getnodeancestors").post(manager -> new PostGetNodeAncestorsResource(box, manager).execute());
		server.route("backservice/getnodedocument").post(manager -> new PostGetNodeDocumentResource(box, manager).execute());
		server.route("backservice/getnodedocumentcontenttype").post(manager -> new PostGetNodeDocumentContentTypeResource(box, manager).execute());
		server.route("backservice/getnodefile").post(manager -> new PostGetNodeFileResource(box, manager).execute());
		server.route("backservice/getnodeflags").post(manager -> new PostGetNodeFlagsResource(box, manager).execute());
		server.route("backservice/getnodelocation").post(manager -> new PostGetNodeLocationResource(box, manager).execute());
		server.route("backservice/getnodenotes").post(manager -> new PostGetNodeNotesResource(box, manager).execute());
		server.route("backservice/getnodereference").post(manager -> new PostGetNodeReferenceResource(box, manager).execute());
		server.route("backservice/getnodereferences").post(manager -> new PostGetNodeReferencesResource(box, manager).execute());
		server.route("backservice/getnodereferencescount").post(manager -> new PostGetNodeReferencesCountResource(box, manager).execute());
		server.route("backservice/getnodeschema").post(manager -> new PostGetNodeSchemaResource(box, manager).execute());
		server.route("backservice/getnodetasks").post(manager -> new PostGetNodeTasksResource(box, manager).execute());
		server.route("backservice/getsourceparentterm").post(manager -> new PostGetSourceParentTermResource(box, manager).execute());
		server.route("backservice/getsourceterms").post(manager -> new PostGetSourceTermsResource(box, manager).execute());
		server.route("backservice/gettaskfacts").post(manager -> new PostGetTaskFactsResource(box, manager).execute());
		server.route("backservice/gettaskflags").post(manager -> new PostGetTaskFlagsResource(box, manager).execute());
		server.route("backservice/gettaskprocess").post(manager -> new PostGetTaskProcessResource(box, manager).execute());
		server.route("backservice/gettasks").post(manager -> new PostGetTasksResource(box, manager).execute());
		server.route("backservice/gettaskshortcuts").post(manager -> new PostGetTaskShortcutsResource(box, manager).execute());
		server.route("backservice/getuserlinkedtonode").post(manager -> new PostGetUserLinkedToNodeResource(box, manager).execute());
		server.route("backservice/getusernode").post(manager -> new PostGetUserNodeResource(box, manager).execute());
		server.route("backservice/getusertasks").post(manager -> new PostGetUserTasksResource(box, manager).execute());
		server.route("backservice/gotoplaceintask").post(manager -> new PostGotoPlaceInTaskResource(box, manager).execute());
		server.route("backservice/haspermissions").post(manager -> new PostHasPermissionsResource(box, manager).execute());
		server.route("backservice/importnode").post(manager -> new PostImportNodeResource(box, manager).execute());
		server.route("backservice/loadsource").post(manager -> new PostLoadSourceResource(box, manager).execute());
		server.route("backservice/loaduser").post(manager -> new PostLoadUserResource(box, manager).execute());
		server.route("backservice/locatenode").post(manager -> new PostLocateNodeResource(box, manager).execute());
		server.route("backservice/locatesource").post(manager -> new PostLocateSourceResource(box, manager).execute());
		server.route("backservice/makenodedeleteable").post(manager -> new PostMakeNodeDeletableResource(box, manager).execute());
		server.route("backservice/makenodeeditable").post(manager -> new PostMakeNodeEditableResource(box, manager).execute());
		server.route("backservice/makenodeprivate").post(manager -> new PostMakeNodePrivateResource(box, manager).execute());
		server.route("backservice/makenodepublic").post(manager -> new PostMakeNodePublicResource(box, manager).execute());
		server.route("backservice/makenodeundeleteable").post(manager -> new PostMakeNodeUndeletableResource(box, manager).execute());
		server.route("backservice/makenodeuneditable").post(manager -> new PostMakeNodeUneditableResource(box, manager).execute());
		server.route("backservice/opendatastore").post(manager -> new PostOpenDatastoreResource(box, manager).execute());
		server.route("backservice/opennode").post(manager -> new PostOpenNodeResource(box, manager).execute());
		server.route("backservice/opentask").post(manager -> new PostOpenTaskResource(box, manager).execute());
		server.route("backservice/recovernode").post(manager -> new PostRecoverNodeResource(box, manager).execute());
		server.route("backservice/removenode").post(manager -> new PostRemoveNodeResource(box, manager).execute());
		server.route("backservice/removetask").post(manager -> new PostRemoveTaskResource(box, manager).execute());
		server.route("backservice/resetnodeform").post(manager -> new PostResetNodeFormResource(box, manager).execute());
		server.route("backservice/resumetask").post(manager -> new PostResumeTaskResource(box, manager).execute());
		server.route("backservice/runtask").post(manager -> new PostRunTaskResource(box, manager).execute());
		server.route("backservice/savenode").post(manager -> new PostSaveNodeResource(box, manager).execute());
		server.route("backservice/savenodedocument").post(manager -> new PostSaveNodeDocumentResource(box, manager).execute());
		server.route("backservice/savenodefile").post(manager -> new PostSaveNodeFileResource(box, manager).execute());
		server.route("backservice/savenodeparent").post(manager -> new PostSaveNodeParentResource(box, manager).execute());
		server.route("backservice/savenodepartnercontext").post(manager -> new PostSaveNodePartnerContextResource(box, manager).execute());
		server.route("backservice/savenodepicture").post(manager -> new PostSaveNodePictureResource(box, manager).execute());
		server.route("backservice/savenodereference").post(manager -> new PostSaveNodeReferenceResource(box, manager).execute());
		server.route("backservice/savenodesattribute").post(manager -> new PostSaveNodesAttributeResource(box, manager).execute());
		server.route("backservice/savetask").post(manager -> new PostSaveTaskResource(box, manager).execute());
		server.route("backservice/saveuser").post(manager -> new PostSaveUserResource(box, manager).execute());
		server.route("backservice/searchevent").post(manager -> new PostSearchEventResource(box, manager).execute());
		server.route("backservice/searchnodes").post(manager -> new PostSearchNodesResource(box, manager).execute());
		server.route("backservice/api").post(manager -> new PostApiResource(box, manager).execute());
		server.route("backservice/subscribe").post(manager -> new PostSubscribeResource(box, manager).execute());
		server.route("backservice/unlocktask").post(manager -> new PostUnlockTaskResource(box, manager).execute());

		return server;
	}
}