/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskPlaceLineTemplate;
import io.intino.goros.unit.box.ui.displays.templates.TaskPlaceLineStopTemplate;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.Formatters;
import java.time.Instant;
import java.util.function.Consumer;
import org.monet.metamodel.LineActionProperty;
import org.monet.metamodel.LineActionPropertyBase;
import org.monet.metamodel.PlaceActionProperty;
import org.monet.metamodel.internal.Lock;
import org.monet.space.kernel.machines.ttm.behavior.ProcessBehavior;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.Task;

public class TaskPlaceLineTemplate
extends AbstractTaskPlaceLineTemplate<UnitBox> {
    private Task task;
    private LineActionProperty property;
    private Consumer<LineActionProperty> resumeListener;
    private static final String DueDateMessage = "%s will be selected if no option is checked before %s";

    public TaskPlaceLineTemplate(UnitBox box) {
        super(box);
    }

    public TaskPlaceLineTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskPlaceLineTemplate property(LineActionProperty property) {
        this.property = property;
        return this;
    }

    public TaskPlaceLineTemplate onResume(Consumer<LineActionProperty> listener) {
        this.resumeListener = listener;
        return this;
    }

    public void refresh() {
        super.refresh();
        this.label.value(Language.getInstance().getModelResource(this.property.getLabel()));
        this.refreshTimeoutMessage();
        this.refreshStops();
    }

    private void refreshTimeoutMessage() {
        Long dueStamp = this.task.getProcess().getTimerDue(this.property.getCode());
        boolean dueDateDefined = dueStamp != -1L;
        this.timeoutMessage.visible(dueDateDefined);
        if (!dueDateDefined) {
            return;
        }
        Language language = Language.getInstance();
        this.timeoutMessage.value(String.format(DueDateMessage, language.getModelResource(this.property.getLabel()), Formatters.shortDate(Instant.ofEpochMilli(dueStamp))));
    }

    private void refreshStops() {
        this.loadingStops.visible(true);
        this.stopsBlock.visible(false);
        this.stops.clear();
        this.property.getStopList().stream().filter(s -> !s.isHidden()).forEach(stop -> this.fill((LineActionPropertyBase.LineStopProperty)stop, (TaskPlaceLineStopTemplate)this.stops.add()));
        this.stopsBlock.visible(true);
        this.loadingStops.visible(false);
    }

    private void fill(LineActionPropertyBase.LineStopProperty stop, TaskPlaceLineStopTemplate view) {
        view.task(this.task);
        view.stop(stop);
        view.confirmText(this.translate(DisplayHelper.requireConfirmationMessage((PlaceActionProperty)this.property)));
        view.onSelect(e -> this.select(stop));
        view.refresh();
    }

    private void select(LineActionPropertyBase.LineStopProperty stop) {
        Lock lock = new Lock(this.task.getProcess().getCurrentPlace().getCode(), stop.getCode());
        ProcessBehavior process = this.task.getProcess();
        process.unlock(lock);
        process.resume();
        this.resumeListener.accept(this.property);
    }
}

