/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskHistoryTemplate;
import io.intino.goros.unit.box.ui.displays.templates.TaskHistoryEntryTemplate;
import io.intino.goros.unit.util.LayerHelper;
import java.util.List;
import org.monet.space.kernel.model.Fact;
import org.monet.space.kernel.model.Task;

public class TaskHistoryTemplate
extends AbstractTaskHistoryTemplate<UnitBox> {
    private Task task;
    private int page = 0;
    private static final int PageSize = 5;

    public TaskHistoryTemplate(UnitBox box) {
        super(box);
    }

    public TaskHistoryTemplate task(Task task) {
        this.task = task;
        this.page = 0;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.moreEntries.onExecute(e -> this.nextPage());
    }

    public void refresh() {
        super.refresh();
        this.refreshEntries();
        this.refreshMore();
    }

    private void refreshEntries() {
        List entryList = LayerHelper.taskLayer().loadTaskFactEntries(this.task.getId(), this.start(this.page), 5);
        if (this.page == 0) {
            this.entriesBlock.visible(false);
            this.entries.clear();
        }
        entryList.forEach(e -> this.fill((Fact)e, (TaskHistoryEntryTemplate)this.entries.add()));
        if (this.page == 0) {
            this.entriesBlock.visible(true);
        }
    }

    private void fill(Fact entry, TaskHistoryEntryTemplate view) {
        view.entry(entry);
        view.refresh();
    }

    private void refreshMore() {
        this.moreEntries.visible(this.entriesCount() > 0 && this.page < this.pageCount() - 1);
    }

    private void nextPage() {
        ++this.page;
        if (this.page >= this.pageCount()) {
            this.page = this.pageCount() - 1;
        }
        this.refresh();
    }

    public int start(int page) {
        return page * 5;
    }

    public int pageCount() {
        return this.pageOf(this.entriesCount());
    }

    public int entriesCount() {
        return LayerHelper.taskLayer().getTaskFactEntriesCount(this.task.getId());
    }

    public int pageOf(long index) {
        return (int)(Math.floor(index / 5L) + (double)(index % 5L > 0L ? 1 : 0));
    }
}

