/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.spark.UIFile;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeDownloadDialog;
import io.intino.goros.unit.box.ui.displays.templates.NodeDownloadDialogOption;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.NodeHelper;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;

public class NodeDownloadDialog
extends AbstractNodeDownloadDialog<UnitBox> {
    private Node node;
    private String view;
    private List<Column> columns = new ArrayList<Column>();
    private Consumer<Boolean> terminateListener;
    private String condition;
    private List<Filter> filters;
    private String sorting;
    private String sortingMode;

    public NodeDownloadDialog(UnitBox box) {
        super(box);
    }

    public NodeDownloadDialog onTerminate(Consumer<Boolean> listener) {
        this.terminateListener = listener;
        return this;
    }

    public NodeDownloadDialog node(Node node) {
        this.node = node;
        return this;
    }

    public NodeDownloadDialog view(String view) {
        this.view = view;
        return this;
    }

    public NodeDownloadDialog condition(String condition) {
        this.condition = condition;
        return this;
    }

    public NodeDownloadDialog filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public NodeDownloadDialog sorting(String sorting, String mode) {
        this.sorting = sorting;
        this.sortingMode = mode;
        return this;
    }

    public NodeDownloadDialog columns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.format.onSelect(e -> this.refreshToolbar());
        this.downloadCancel.onExecute(e -> this.terminateListener.accept(true));
        this.downloadAccept.onExecute(e -> this.accept());
    }

    public void refresh() {
        super.refresh();
        this.refreshColumns();
        this.downloadAccept.readonly(true);
    }

    private boolean check() {
        if (this.format.selection().size() <= 0) {
            return false;
        }
        return this.options.children(NodeDownloadDialogOption.class).stream().anyMatch(c -> c.selectedColumn() != null);
    }

    private List<Column> dateColumns() {
        return this.columns.stream().filter(Column::isDate).collect(Collectors.toList());
    }

    private UIFile accept() {
        this.terminateListener.accept(true);
        this.notifyUser(this.translate("Downloading data..."), UserMessage.Type.Info);
        final String format = (String)this.format.selection().get(0);
        List<String> selection = this.selectedColumns();
        final InputStream result = NodeHelper.download((UnitBox)this.box(), this.node, this.request(), format, selection, this.language());
        this.notifyUser(this.translate("Download finished"), UserMessage.Type.Success);
        return new UIFile(){

            public String label() {
                return NodeDownloadDialog.this.node.getLabel() + "_" + Formatters.downloadDate(Instant.now()) + "." + format.toLowerCase();
            }

            public InputStream content() {
                return result;
            }
        };
    }

    private NodeDataRequest request() {
        NodeDataRequest dataRequest = new NodeDataRequest();
        dataRequest.setCodeDomainNode(this.node.getDefinition().getCode());
        dataRequest.setCodeView(this.view);
        dataRequest.setCondition(this.condition);
        dataRequest.setGroupsBy(NodeHelper.groupsByOf(this.filters));
        if (this.sorting != null) {
            dataRequest.setSortsBy(NodeHelper.sortsByOf(Collections.singletonList(NodeHelper.sortingOf(this.sorting, this.sortingMode))));
        }
        return dataRequest;
    }

    private List<String> selectedColumns() {
        List children = this.options.children(NodeDownloadDialogOption.class);
        return children.stream().map(NodeDownloadDialogOption::selectedColumn).filter(Objects::nonNull).map(Column::code).collect(Collectors.toList());
    }

    private void refreshColumns() {
        this.columnsBlock.hide();
        this.options.clear();
        for (int i = 0; i < this.columns.size(); ++i) {
            this.fill(i, (NodeDownloadDialogOption)this.options.add());
        }
        this.columnsBlock.show();
    }

    private void fill(int pos, NodeDownloadDialogOption view) {
        view.index(pos);
        view.columns(this.columns);
        view.onSelect(e -> this.refreshToolbar());
        view.refresh();
    }

    private void refreshToolbar() {
        this.downloadAccept.readonly(!this.check());
    }
}

