/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractGorosInstallTemplate;
import io.intino.goros.unit.util.Formatters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.monet.metamodel.Distribution;
import org.monet.metamodel.Project;
import org.monet.space.kernel.Kernel;
import org.monet.space.kernel.agents.AgentFilesystem;
import org.monet.space.kernel.agents.AgentLogger;
import org.monet.space.kernel.components.ComponentDocuments;
import org.monet.space.kernel.components.ComponentFederation;
import org.monet.space.kernel.components.ComponentPersistence;
import org.monet.space.kernel.configuration.Configuration;
import org.monet.space.kernel.deployer.DeployLogger;
import org.monet.space.kernel.deployer.DeployerPipeline;
import org.monet.space.kernel.model.BusinessUnit;

public class GorosInstallTemplate
extends AbstractGorosInstallTemplate<UnitBox> {
    private Resource model = null;

    public GorosInstallTemplate(UnitBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        if (BusinessUnit.getInstance().isInstalled()) {
            ((TemplateNotifier)this.notifier).redirect(this.session().browser().baseUrl());
            return;
        }
        ((UnitBox)this.box()).initSession(this.session());
        this.title.value(Formatters.firstUpperCase(((UnitBox)this.box()).configuration().name()) + " " + this.translate("model not defined"));
        this.description.value(this.translate("Upload") + " " + Formatters.firstUpperCase(((UnitBox)this.box()).configuration().name()) + " " + this.translate("model by using eclipse IDE or drag and drop here"));
        this.upload.onExecute(e -> this.updateModel());
        this.modelFile.onUploading(e -> {
            this.model = null;
            this.upload.readonly(true);
            this.uploading.visible(true);
        });
        this.modelFile.onChange(e -> {
            this.uploading.visible(false);
            this.model = (Resource)e.value();
            this.upload.readonly(false);
        });
    }

    private void updateModel() {
        this.upload.readonly(true);
        if (this.model == null) {
            return;
        }
        this.loggingBlock.visible(true);
        this.logEntries.clear();
        if (!ComponentDocuments.getInstance().ping()) {
            this.notifyUser(this.translate("Could not upload distribution. DocService is DOWN."), UserMessage.Type.Error);
            this.upload.readonly(false);
            return;
        }
        if (!this.executeDeployer()) {
            this.notifyUser("Model updated successfully", UserMessage.Type.Success);
            this.upload.readonly(false);
            return;
        }
        ((TemplateNotifier)this.notifier).redirect(this.session().browser().baseUrl());
    }

    private boolean executeDeployer() {
        try {
            Kernel kernel = Kernel.getInstance();
            Configuration monetConfiguration = kernel.getConfiguration();
            BusinessUnit businessUnit = BusinessUnit.getInstance();
            DeployerPipeline pipeline = new DeployerPipeline((DeployLogger)new DeployerLogger());
            String destination = monetConfiguration.getTempDir() + "/" + UUID.randomUUID().toString();
            String businessModelZipLocation = monetConfiguration.getBusinessModelZipLocation();
            kernel.stopApplications();
            File tempModelFile = File.createTempFile("mml", ".zip");
            AgentFilesystem.writeFile((File)tempModelFile, (InputStream)this.model.stream());
            pipeline.setData("MODEL_STREAM", (Object)tempModelFile);
            pipeline.setData("MODEL_INSTALL_DIRECTORY", (Object)monetConfiguration.getBusinessModelDir());
            pipeline.setData("TEMP_DIRECTORY", (Object)monetConfiguration.getTempDir());
            pipeline.setData("WORKING_DIRECTORY", (Object)destination);
            pipeline.setData("COMPONENT_PERSISTENCE", (Object)ComponentPersistence.getInstance());
            pipeline.setData("COMPONENT_FEDERATION", (Object)ComponentFederation.getInstance());
            pipeline.setData("COMPONENT_DOCUMENTS", (Object)ComponentDocuments.getInstance());
            pipeline.setData("BUSINESS_UNIT", (Object)businessUnit);
            pipeline.setData("BUSINESS_MODEL_ZIP_LOCATION", (Object)businessModelZipLocation);
            pipeline.process();
            Distribution distribution = businessUnit.getDistribution();
            Project project = businessUnit.getBusinessModel().getProject();
            businessUnit.setLabel(BusinessUnit.getSubTitle((Distribution)distribution, (Project)project));
            businessUnit.save();
            if (BusinessUnit.autoRun().booleanValue() && !BusinessUnit.isRunning()) {
                businessUnit.run();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return false;
        }
        return true;
    }

    private class DeployerLogger
    implements DeployLogger {
        private AgentLogger logger = AgentLogger.getInstance();

        private DeployerLogger() {
        }

        public void info(String message, Object ... args) {
            this.logger.infoInModel(message, args);
            GorosInstallTemplate.this.logEntries.add("[INFO] " + String.format(message, args)).color("#2896F3");
        }

        public void error(Throwable exception) {
            this.logger.errorInModel(exception);
        }

        public void error(String message, Object ... args) {
            String errorMsg = message != null && args != null ? String.format(message, args) : message;
            this.logger.errorInModel(errorMsg, null);
            GorosInstallTemplate.this.logEntries.add("[ERROR] " + errorMsg).color("#F44335");
        }

        public void debug(String message, Object ... args) {
            this.logger.debugInModel(message, args);
            GorosInstallTemplate.this.logEntries.add("[DEBUG] " + String.format(message, args)).color("#F89804");
        }
    }
}

