/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.listeners;

import io.intino.alexandria.ui.displays.Display;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.monet.space.kernel.components.ComponentPersistence;
import org.monet.space.kernel.model.Task;

public class GorosUnitNotifier {
    private Map<String, Consumer<Task>> taskCreatedListeners = new HashMap<String, Consumer<Task>>();
    private Map<String, Consumer<Task>> taskStateChangeListeners = new HashMap<String, Consumer<Task>>();

    public GorosUnitNotifier onTaskCreated(Display display, Consumer<Task> listener) {
        this.taskCreatedListeners.put(this.idOf(display), listener);
        return this;
    }

    public GorosUnitNotifier unTaskCreated(Display display) {
        if (!this.taskCreatedListeners.containsKey(this.idOf(display))) {
            return this;
        }
        this.taskCreatedListeners.remove(this.idOf(display));
        return this;
    }

    public GorosUnitNotifier onTaskStateChange(Display display, Consumer<Task> listener) {
        this.taskStateChangeListeners.put(this.idOf(display), listener);
        return this;
    }

    public GorosUnitNotifier unTaskStateChange(Display display) {
        String id = this.idOf(display);
        if (!this.taskStateChangeListeners.containsKey(id)) {
            return this;
        }
        this.taskStateChangeListeners.remove(id);
        return this;
    }

    public void notifyTaskCreated(Task task) {
        Task loadedTask = ComponentPersistence.getInstance().getTaskLayer().loadTask(task.getId());
        this.taskCreatedListeners.values().forEach(l -> l.accept(loadedTask));
    }

    public void notifyTaskStateChange(Task task) {
        this.notifyTaskStateChange(task.getId());
    }

    public void notifyTaskStateChange(String task) {
        Task loadedTask = ComponentPersistence.getInstance().getTaskLayer().loadTask(task);
        this.taskStateChangeListeners.values().forEach(l -> l.accept(loadedTask));
    }

    private String idOf(Display display) {
        String id = display.id();
        return display.owner() != null ? id + display.owner().path() : id + display.hashCode();
    }
}

