/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TrashDatasource;
import io.intino.goros.unit.box.ui.displays.rows.TrashTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTrashTableCatalog;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import org.monet.space.kernel.model.Node;

public class TrashTableCatalog
extends AbstractTrashTableCatalog<UnitBox> {
    public TrashTableCatalog(UnitBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.trashTable.source((Datasource)new TrashDatasource((UnitBox)this.box(), this.session()));
        this.trashTable.onAddItem(e -> {
            Node node = (Node)e.item();
            TrashTableRow row = (TrashTableRow)e.component();
            row.trashTableLabelItem.label.value(node.getLabel() != null && !node.getLabel().isEmpty() ? node.getLabel() : "-");
            row.trashTableTypeItem.type.value(node.getDefinition().getLabelString());
            row.trashTableDeleteDateItem.deleteDate.value(NodeHelper.instantOf(node.getReference().getDeleteDate()));
            row.trashTableOperationsItem.restore.onExecute(e1 -> this.restore(node));
        });
    }

    public void refresh() {
        super.refresh();
        this.trashTable.reload();
    }

    private void restore(Node node) {
        LayerHelper.nodeLayer().recoverNodeFromTrash(node.getId());
        this.refresh();
    }
}

