/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import java.text.Normalizer;
import java.util.Arrays;

public class DatasourceHelper {
    public static boolean matches(String value, String[] conditions) {
        if (value == null) {
            return false;
        }
        String cleanedValue = DatasourceHelper.clean(value.toLowerCase());
        return Arrays.stream(conditions).allMatch(c -> cleanedValue.contains(DatasourceHelper.clean(c)));
    }

    private static String clean(String value) {
        value = Normalizer.normalize(value, Normalizer.Form.NFD);
        value = value.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return value;
    }
}

