/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import io.intino.alexandria.ui.model.PlaceMark;
import io.intino.alexandria.ui.model.datasource.BoundingBox;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.MapDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.SetDefinition;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;
import org.monet.space.kernel.model.map.GeometryHelper;
import org.monet.space.kernel.model.map.Location;

public class CollectionMapDatasource
extends MapDatasource<Node> {
    private final UnitBox box;
    private final UISession session;
    private final Node set;
    private final NodeViewProperty view;

    public CollectionMapDatasource(UnitBox box, UISession session, Node set, String view) {
        this.box = box;
        this.session = session;
        this.set = set;
        this.view = set.getDefinition().getNodeView(view);
    }

    public List<PlaceMark<Node>> placeMarks(String condition, List<Filter> filters, BoundingBox boundingBox) {
        NodeDataRequest request = this.request(condition, filters);
        request.setStartPos(Integer.valueOf(0));
        request.setLimit(Integer.valueOf(1000000));
        request.setBoundingBox(this.boundingBoxOf(boundingBox));
        this.box.linkSession(this.session);
        return new ArrayList<PlaceMark<Node>>(LayerHelper.nodeLayer().requestNodeListItems(this.set.getId(), request).values().stream().map(node -> CollectionMapDatasource.placeMarkOf(node)).collect(Collectors.toList()));
    }

    public long placeMarkCount(String condition, List<Filter> filters) {
        this.box.linkSession(this.session);
        return LayerHelper.nodeLayer().requestNodeListItemsCount(this.set.getId(), this.request(condition, filters));
    }

    public List<Group> groups(String key) {
        List groups = this.set.getGroupOptions(key, Collections.emptyList(), Collections.emptyList());
        return groups.stream().map(o -> new Group().label(o)).collect(Collectors.toList());
    }

    public static PlaceMark<Node> placeMarkOf(Node node) {
        Location location = node.getLocation();
        PlaceMark placeMark = PlaceMark.build((String)node.getLabel(), location != null && location.getGeometry() != null ? location.getGeometry().toText() : null);
        placeMark.item((Object)node);
        return placeMark;
    }

    public static long itemCount(Node set) {
        return LayerHelper.nodeLayer().requestNodeListItemsCount(set.getId(), CollectionMapDatasource.request(set));
    }

    private NodeDataRequest request(String condition, List<Filter> filters) {
        NodeDataRequest request = CollectionMapDatasource.request(this.set);
        request.setCondition(condition);
        request.setGroupsBy(NodeHelper.groupsByOf(filters));
        request.setCodeView(this.view.getCode());
        return request;
    }

    private static NodeDataRequest request(Node set) {
        NodeDataRequest request = new NodeDataRequest();
        request.setCodeReference(((SetDefinition)set.getDefinition()).getIndex().getValue());
        return request;
    }

    private Polygon boundingBoxOf(BoundingBox boundingBox) {
        if (boundingBox == null) {
            return null;
        }
        double dnex = boundingBox.northEast().longitude();
        double dney = boundingBox.northEast().latitude();
        double dswx = boundingBox.southWest().longitude();
        double dswy = boundingBox.southWest().latitude();
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(dswx, dney), new Coordinate(dnex, dney), new Coordinate(dnex, dswy), new Coordinate(dswx, dswy), new Coordinate(dswx, dney)};
        CoordinateArraySequence sequence = new CoordinateArraySequence(coordinates);
        return new Polygon(new LinearRing((CoordinateSequence)sequence, GeometryHelper.getFactory()), null, GeometryHelper.getFactory());
    }
}

