/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.install;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.shared.install.Db;
import io.intino.goros.shared.install.Files;
import io.intino.goros.shared.install.Shell;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class Installer {
    private Db db;
    private String workspace;
    private String spaceName;
    String fileNameSSL;
    String fileNameSSLPassword;
    String federationCAPassword;
    String federationCAFileCrt;
    String federationCAFileKey;

    public Installer(Map<String, String> parameters) {
        String DbUrl = parameters.get("Jdbc.Url");
        String DbUser = parameters.get("Jdbc.User");
        String DbPassword = parameters.get("Jdbc.Password");
        this.db = new Db(DbUrl, DbUser, DbPassword);
        this.workspace = parameters.get("MONET_WORKSPACE");
        this.spaceName = parameters.get("MONET_NAME");
        this.fileNameSSL = this.workspace + "/certificates/" + FilenameUtils.getBaseName((String)parameters.get("MONET_CERTIFICATE_FILENAME"));
        this.fileNameSSLPassword = parameters.get("MONET_CERTIFICATE_PASSWORD");
        this.federationCAPassword = parameters.get("MONET_CERTIFICATE_CA_KEY_PASSWORD");
        this.federationCAFileCrt = parameters.get("MONET_CERTIFICATE_CA_CRT_FILENAME");
        this.federationCAFileKey = parameters.get("MONET_CERTIFICATE_CA_KEY_FILENAME");
    }

    public void initWorkspace() {
        File f = new File(this.workspace);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public boolean isInstalled() {
        return this.isDBInstalled() && this.isLogsInstalled() && this.isCertificatesInstalled() && this.isCacheInstalled();
    }

    public void processDB() {
        if (this.isDBInstalled()) {
            return;
        }
        Logger.info((String)"Install database...");
        String sqlScript = "/kernel/database/mysql.sql";
        InputStream in = Installer.class.getResourceAsStream(sqlScript);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            this.db.executeScript((Reader)reader);
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void processLogs() {
        if (this.isLogsInstalled()) {
            return;
        }
        Logger.info((String)"Install log configuration...");
        String log4jDist = "/WEB-INF/user_data/configuration/log4j.dist.config";
        InputStream in = Installer.class.getResourceAsStream(log4jDist);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        File fileLog4j = new File(this.workspace + "/configuration/log4j.config");
        fileLog4j.getParentFile().mkdirs();
        Files.makeDir((String)(this.workspace + "/logs"));
        try {
            Files.saveReaderFile((Reader)reader, (File)fileLog4j);
            Files.replaceTextInFile((File)fileLog4j, (String)"#config_path#", (String)this.workspace);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void processCertificates() {
        if (this.isCertificatesInstalled()) {
            return;
        }
        Shell shell = new Shell();
        Files.makeDir((String)(this.workspace + "/certificates"));
        Logger.info((String)"Generate space key");
        String command = "openssl genrsa -des3 -passout pass:" + this.fileNameSSLPassword + " -out " + this.fileNameSSL + ".key 4096";
        Integer exitCode = shell.executeCommand(command, new File(new File(this.fileNameSSL).getParent()));
        if (exitCode > 0) {
            Logger.error((String)"I can not generate certificates.");
        }
        Logger.info((String)"Generate space certificate");
        command = "openssl req -new -passin pass:" + this.fileNameSSLPassword + " -key " + this.fileNameSSL + ".key -out " + this.fileNameSSL + ".csr -subj \"/C=ES/ST=Las Palmas de Gran Canaria/L=Tafira/O=CES/OU=Calidad, Eficiencia y Sostenibilidad/CN=business_unit|" + this.spaceName + "/emailAddress=info@openmonet.com/\"";
        exitCode = shell.executeCommand(command, new File(new File(this.fileNameSSL).getParent()));
        if (exitCode > 0) {
            Logger.error((String)"I can not generate certificates.");
        }
        Logger.info((String)"Signing certificate");
        command = "openssl x509 -req -passin pass:" + this.federationCAPassword + " -days 3650 -CA " + this.federationCAFileCrt + " -CAkey " + this.federationCAFileKey + " -set_serial 01 -in " + this.fileNameSSL + ".csr -out " + this.fileNameSSL + ".crt";
        exitCode = shell.executeCommand(command, new File(new File(this.fileNameSSL).getParent()));
        if (exitCode > 0) {
            Logger.error((String)"I can not generate certificates.");
        }
        Logger.info((String)"Export certificate");
        command = "openssl pkcs12 -export -passin pass:" + this.fileNameSSLPassword + " -passout pass:" + this.fileNameSSLPassword + " -out " + this.fileNameSSL + ".p12 -inkey " + this.fileNameSSL + ".key -in " + this.fileNameSSL + ".crt -certfile " + this.federationCAFileCrt;
        exitCode = shell.executeCommand(command, new File(new File(this.fileNameSSL).getParent()));
        if (exitCode > 0) {
            Logger.error((String)"I can not generate certificates.");
        }
    }

    public void processCache() {
        if (this.isLogsInstalled()) {
            return;
        }
        Logger.info((String)"Install cache configuration...");
        String cacheDist = "/WEB-INF/user_data/configuration/cache.dist.ccf";
        InputStream in = Installer.class.getResourceAsStream(cacheDist);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        File fileCache = new File(this.workspace + "/configuration/cache.ccf");
        fileCache.getParentFile().mkdirs();
        try {
            Files.saveReaderFile((Reader)reader, (File)fileCache);
            Files.replaceTextInFile((File)fileCache, (String)"#space_dir#", (String)this.workspace);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private boolean isDBInstalled() {
        try {
            String count = this.db.executeSentence("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '" + this.db.getDbname() + "' and table_name = 'ts\\$info'");
            return !count.isEmpty() && Integer.parseInt(count) > 0;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return true;
    }

    private boolean isLogsInstalled() {
        File f = new File(this.workspace + "/configuration/log4j.config");
        return f.exists() && !f.isDirectory();
    }

    private boolean isCertificatesInstalled() {
        File f = new File(this.fileNameSSL + ".key");
        return f.exists() && !f.isDirectory();
    }

    private boolean isCacheInstalled() {
        File f = new File(this.workspace + "/configuration/cache.ccf");
        return f.exists() && !f.isDirectory();
    }
}

