/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.actions;

import io.intino.alexandria.Context;
import io.intino.goros.unit.box.actions.Action;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import org.monet.http.Request;
import org.monet.http.Response;
import org.monet.space.applications.ServiceAction;
import org.monet.space.kernel.agents.AgentSession;
import org.monet.space.kernel.model.Account;
import org.monet.space.kernel.model.Session;

public abstract class SetupServiceAction
extends Action {
    private static final String USER_LANGUAGE = "USER_LANGUAGE";
    private static Set<String> supportedLanguages;
    private static final String ENGLISH = "en";
    private static final String SPANISH = "es";
    private String idSession;

    abstract Map<String, Object> parameters();

    public String executeServiceAction(ServiceAction action) {
        this.initialize();
        HashMap parameters = (HashMap)this.parameters();
        Request request = this.request(parameters);
        action.setRequest(request);
        action.setResponse((Response)this.response);
        action.setParameters(parameters);
        this.fillCurrentLanguage(request);
        return action.execute();
    }

    private void initialize() {
        this.idSession = this.createSession();
        org.monet.space.kernel.model.Context _context = org.monet.space.kernel.model.Context.getInstance();
        Long idThread = Thread.currentThread().getId();
        _context.setApplication(idThread, (String)this.context.get((Object)"realIp"), "backservice", "user");
        URL url = null;
        try {
            url = new URL((String)this.context.get((Object)"requestUrl"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        _context.setUserServerConfig(idThread, url.getHost(), url.getPath(), Integer.valueOf(url.getPort()));
        _context.setSessionId(idThread, this.idSession);
        _context.setDatabaseConnectionType(idThread, "auto");
        this.response = new io.intino.goros.unit.box.services.Response((Context)this.context);
    }

    private String createSession() {
        String idSession;
        AgentSession agentSession = AgentSession.getInstance();
        Session session = agentSession.get(idSession = UUID.randomUUID().toString());
        if (session == null) {
            agentSession.add(idSession);
        }
        return idSession;
    }

    private static void initLanguages() {
        if (supportedLanguages == null) {
            supportedLanguages = new HashSet<String>();
            supportedLanguages.add(SPANISH);
            supportedLanguages.add(ENGLISH);
        }
    }

    private void fillCurrentLanguage(Request request) {
        Session session = AgentSession.getInstance().get(this.idSession);
        SetupServiceAction.initLanguages();
        String requestLanguage = request.getParameter("language");
        if (requestLanguage != null) {
            session.setVariable(USER_LANGUAGE, (Object)requestLanguage);
        } else {
            String prefLanguage = request.getHeader("Accept-Language");
            Account account = session.getAccount();
            if (account != null) {
                session.setVariable(USER_LANGUAGE, (Object)account.getUser().getLanguage());
                return;
            }
            if (prefLanguage != null) {
                String language = null;
                StringTokenizer acceptLanguageTokenizer = new StringTokenizer(prefLanguage, ",");
                int elements = acceptLanguageTokenizer.countTokens();
                for (int idx = 0; idx < elements; ++idx) {
                    String acceptLang = acceptLanguageTokenizer.nextToken();
                    StringTokenizer langTokenizer = new StringTokenizer(acceptLang, "-");
                    if (langTokenizer.countTokens() == 2) {
                        acceptLang = langTokenizer.nextToken();
                    }
                    if (!supportedLanguages.contains(acceptLang)) continue;
                    language = acceptLang;
                    break;
                }
                if (language == null) {
                    language = SPANISH;
                }
                session.setVariable(USER_LANGUAGE, (Object)language);
            } else {
                String language = (String)session.getVariable(USER_LANGUAGE);
                if (language == null) {
                    session.setVariable(USER_LANGUAGE, (Object)SPANISH);
                }
            }
        }
    }
}

