import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import ComboFilterTemplateMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import ComboFilterTemplateMoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ComboFilterTemplateMold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new ComboFilterTemplateMoldNotifier(this);
		this.requester = new ComboFilterTemplateMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2031355464" mode="normal">
				</UiText>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ComboFilterTemplateMold));
DisplayFactory.register("ComboFilterTemplateMold", withStyles(styles, { withTheme: true })(withSnackbar(ComboFilterTemplateMold)));