import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import PublishTermsDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import PublishTermsDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PublishTermsDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new PublishTermsDialogNotifier(this);
		this.requester = new PublishTermsDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470" format="doubleAirBottom middleSpaced leftSpaced rightSpaced" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1469588770" format="h5 airBottom" mode="normal" translate={true} value="New terms added recently that are not published yet">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955" format="bordered dialog" layout="vertical">
						<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a_1322977869" multipleSelection={false} layout="Horizontal">
						</UiSelectorCheckBox>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929" layout="horizontal">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929.a1393352634" format="airRight" layout="vertical" width="120px" height="-1px">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929.a1393352634.a_1292147736" title="Publish" target="self" mode="Button" readonly={true} size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929.a_1342289349" format="airRight" layout="vertical" width="120px" height="-1px">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929.a_1342289349.a913178168" title="Publish all" target="self" mode="Button" size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929.a1225314331" layout="vertical" width="120px" height="-1px">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_872329470.a_1748168955.a1833447929.a1225314331.a_377101840" title="Delete" target="self" mode="Button" readonly={true} size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(PublishTermsDialog));
DisplayFactory.register("PublishTermsDialog", withStyles(styles, { withTheme: true })(withSnackbar(PublishTermsDialog)));