import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorRadioBox from "alexandria-ui-elements/src/displays/components/SelectorRadioBox";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import DisplaysDownloadDialogOption from "unit-elements/gen/displays/templates/DownloadDialogOption";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TaskDownloadDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TaskDownloadDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TaskDownloadDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TaskDownloadDialogNotifier(this);
		this.requester = new TaskDownloadDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897" format="autoOverflow" layout="flexible" width="100.0%" height="calc(100% - 50px)">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_687905351" format="airBottom" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_687905351.a_1138891799" format="airBottom" mode="normal" value="Indique el formato de descarga">
						</UiText>
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_687905351.a_1798054998" multipleSelection={false} placeholder="Seleccione un formato" maxMenuHeight={300}>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_687905351.a_1798054998.a183949021" name="pdf" mode="normal" value="Formato de documento portátil (pdf)">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_687905351.a_1798054998.a183937009" name="csv" mode="normal" value="Valores separados por coma (csv)">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_687905351.a_1798054998.a183956970" name="xls" mode="normal" value="Documento de Excel (xls)">
							</UiText>
						</UiSelectorComboBox>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_146274139" format="airBottom doubleAirTop" layout="vertical">
						<UiSelectorRadioBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_146274139.a_1766097166" label="Indique las columnas de la cabecera del documento" multipleSelection={false} layout="Vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_146274139.a_1766097166.a_132367767" name="allColumns" mode="normal" value="Todas las columnas">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_146274139.a_1766097166.a_373336929" name="customColumns" mode="normal" value="Seleccionar las columnas del documento">
							</UiText>
						</UiSelectorRadioBox>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_146274139.a766658203" visible={false} layout="vertical">
							<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1983267897.a_146274139.a766658203.a428976378" multiple={{instances:"options",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
							</UiMultiple>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_840867489">
				</UiDivider>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1647366937" layout="horizontal endjustified">
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1647366937.a_1760942603" title="Cancelar" target="self" mode="Button" size="Small" format="airRight">
					</UiAction>
					<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1647366937.a_1816679293" title="Aceptar" target="self" mode="Button" size="Small">
					</UiDownload>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TaskDownloadDialog));
DisplayFactory.register("TaskDownloadDialog", withStyles(styles, { withTheme: true })(withSnackbar(TaskDownloadDialog)));