/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.Formatters;
import io.intino.goros.modernizing.monet.renderers.Renderer;
import io.intino.itrules.Engine;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.monet.metamodel.ActivityDefinition;
import org.monet.metamodel.Definition;
import org.monet.metamodel.DefinitionBase;
import org.monet.metamodel.DesktopDefinition;
import org.monet.metamodel.DesktopDefinitionBase;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.ProcessDefinition;
import org.monet.metamodel.ServiceDefinition;
import org.monet.metamodel.TaskDefinition;
import org.monet.metamodel.internal.Ref;

public abstract class DefinitionRenderer<D extends Definition>
extends Renderer {
    private final D definition;
    private final Set<String> addedDisplays = new HashSet<String>();

    public DefinitionRenderer(Dictionary dictionary, Modernization modernization, D definition) {
        super(dictionary, modernization);
        this.definition = definition;
    }

    public D definition() {
        return this.definition;
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        this.writeJava(builder);
        this.writeKonos(builder);
    }

    protected abstract FrameBuilder buildFrame();

    protected abstract Template konosTemplate();

    protected abstract Template javaTemplate();

    protected void resetAddedDisplays() {
        this.addedDisplays.clear();
    }

    protected FrameBuilder baseDefinitionFrame() {
        FrameBuilder result = super.baseFrame();
        result.add("name", this.nameOf((Definition)this.definition));
        result.add("code", ((DefinitionBase)this.definition).getCode());
        result.add("label", this.clean(((DefinitionBase)this.definition()).getLabel()));
        if (((Definition)this.definition).getType() != null) {
            result.add(((Definition)this.definition).getType().name());
            if (this.definition instanceof ProcessDefinition) {
                result.add("process");
            }
        }
        return result;
    }

    protected void addDisplayFor(NodeDefinition definition, String view, FrameBuilder builder) {
        this.addDisplayFor(definition, definition.getNodeView(view), builder);
    }

    protected void addDisplayFor(NodeDefinition definition, NodeViewProperty view, FrameBuilder builder) {
        NodeViewProperty viewProperty;
        FrameBuilder result = this.baseFrame().add("display");
        NodeViewProperty nodeViewProperty = viewProperty = view != null ? view : this.findEmbeddedView(definition);
        if (viewProperty == null) {
            return;
        }
        String key = definition.getCode() + viewProperty.getCode();
        if (this.addedDisplays.contains(key)) {
            return;
        }
        result.add("name", this.nameOf(definition));
        result.add("code", definition.getCode());
        result.add("viewName", this.nameOf(viewProperty));
        result.add("viewCode", viewProperty.getCode());
        this.addedDisplays.add(key);
        builder.add("display", result);
    }

    protected void addDesktop(FrameBuilder result) {
        DesktopDefinition desktop = this.desktopWithDefinition((Definition)this.definition());
        if (desktop == null) {
            return;
        }
        result.add("desktop", this.desktopFrame(desktop));
    }

    protected FrameBuilder desktopFrame(DesktopDefinition desktopDefinition) {
        FrameBuilder result = this.baseFrame().add("desktop");
        if (desktopDefinition.isSingleton()) {
            result.add("singleton");
        }
        result.add("name", this.nameOf(desktopDefinition));
        result.add("label", this.clean(desktopDefinition.getLabel()));
        this.addResourceType(desktopDefinition, result);
        return result;
    }

    protected void addRecentTaskType(TaskDefinition definition, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("tasktype");
        result.add("name", this.nameOf(definition));
        result.add("code", definition.getCode());
        builder.add("tasktype", result);
    }

    protected List<TaskDefinition> findTaskDefinitionsWith(Definition definition) {
        return this.dictionary.getTaskDefinitionList().stream().filter(d -> this.contains((TaskDefinition)d, definition)).collect(Collectors.toList());
    }

    private boolean contains(TaskDefinition taskDefinition, Definition definition) {
        if (taskDefinition.isJob()) {
            return false;
        }
        Ref target = taskDefinition.isActivity() ? ((ActivityDefinition)taskDefinition).getTarget() : ((ServiceDefinition)taskDefinition).getTarget();
        return target != null && this.dictionary.getDefinitionCode(target.getValue()).equals(definition.getCode());
    }

    private boolean containsDefinition(DesktopDefinitionBase.ViewProperty viewProperty) {
        DesktopDefinitionBase.ViewProperty.ShowProperty show = viewProperty.getShow();
        return show.getLink().stream().anyMatch(l -> this.dictionary.getDefinition(l.getValue()).getCode().equals(((DefinitionBase)this.definition()).getCode()));
    }

    protected void writeJava(FrameBuilder builder) {
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition) + "Template.java");
        this.writeFrame(file, new Engine(this.javaTemplate()).addAll(Formatters.all).render(builder.toFrame()));
    }

    protected void writeKonos(FrameBuilder builder) {
        File file = new File(this.konosPackage() + this.nameOf((Definition)this.definition) + ".konos");
        this.writeFrame(file, new Engine(this.konosTemplate()).addAll(Formatters.all).render(builder.toFrame()));
    }

    private NodeViewProperty findEmbeddedView(NodeDefinition definition) {
        NodeViewProperty defaultView = definition.getDefaultView();
        if (defaultView != null && defaultView.isVisibleWhenEmbedded()) {
            return defaultView;
        }
        return definition.getViewDefinitionList().stream().filter(NodeViewProperty::isVisibleWhenEmbedded).findFirst().orElse(definition.getDefaultView());
    }
}

