/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.monet.metamodel.DatastoreDefinitionBase;
import org.monet.metamodel.interfaces.IsInitiable;
import org.monet.space.kernel.model.DefinitionType;

public class DatastoreDefinition
extends DatastoreDefinitionBase
implements IsInitiable {
    HashMap<String, ArrayList<DatastoreDefinitionBase.DimensionProperty>> dimensionsWithOntologyMap = new HashMap();
    HashMap<String, DatastoreDefinitionBase.CubeProperty> cubeMap = new HashMap();
    HashMap<String, DatastoreDefinitionBase.DimensionProperty> dimensionMap = new HashMap();
    HashMap<String, DatastoreDefinitionBase.DimensionProperty.FeatureProperty> featureMap = new HashMap();
    HashMap<String, DatastoreDefinitionBase.CubeProperty.MetricProperty> metricMap = new HashMap();

    @Override
    public DefinitionType getType() {
        return DefinitionType.datastore;
    }

    @Override
    public void init() {
        for (DatastoreDefinitionBase.DimensionProperty dimensionDefinition : this.getDimensionList()) {
            String ontology = dimensionDefinition.getOntology();
            if (!this.dimensionsWithOntologyMap.containsKey(ontology)) {
                this.dimensionsWithOntologyMap.put(ontology, new ArrayList());
            }
            ArrayList<DatastoreDefinitionBase.DimensionProperty> dimensionList = this.dimensionsWithOntologyMap.get(ontology);
            dimensionList.add(dimensionDefinition);
            this.dimensionMap.put(dimensionDefinition.getName(), dimensionDefinition);
            this.dimensionMap.put(dimensionDefinition.getCode(), dimensionDefinition);
            for (DatastoreDefinitionBase.DimensionProperty.FeatureProperty featureDefinition : dimensionDefinition.getFeatureList()) {
                String name = featureDefinition.getName();
                String code = featureDefinition.getCode();
                this.featureMap.put(name, featureDefinition);
                this.featureMap.put(code, featureDefinition);
            }
        }
        for (DatastoreDefinitionBase.CubeProperty cubeDefinition : this.getCubeList()) {
            this.cubeMap.put(cubeDefinition.getName(), cubeDefinition);
            this.cubeMap.put(cubeDefinition.getCode(), cubeDefinition);
            for (DatastoreDefinitionBase.CubeProperty.MetricProperty metricDefinition : cubeDefinition.getMetricList()) {
                String name = metricDefinition.getName();
                String code = metricDefinition.getCode();
                this.metricMap.put(name, metricDefinition);
                this.metricMap.put(code, metricDefinition);
            }
        }
    }

    public DatastoreDefinitionBase.DimensionProperty getDimension(String key) {
        return this.dimensionMap.get(key);
    }

    public List<DatastoreDefinitionBase.DimensionProperty> getDimensionsWithOntology(String ontology) {
        if (!this.dimensionsWithOntologyMap.containsKey(ontology)) {
            return new ArrayList<DatastoreDefinitionBase.DimensionProperty>();
        }
        return this.dimensionsWithOntologyMap.get(ontology);
    }

    public DatastoreDefinitionBase.DimensionProperty.FeatureProperty getFeature(String key) {
        return this.featureMap.get(key);
    }

    public DatastoreDefinitionBase.CubeProperty getCube(String key) {
        return this.cubeMap.get(key);
    }

    public DatastoreDefinitionBase.CubeProperty.MetricProperty getMetric(String key) {
        return this.metricMap.get(key);
    }

    public static class FeatureProperty
    extends DatastoreDefinitionBase.DimensionProperty.FeatureProperty {
        public static final String EXTRA_FEATURE_SUFFIX = "_extra";
    }
}

