/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.definition.NodeRenderer;
import io.intino.goros.modernizing.monet.renderers.templates.java.FormTemplate;
import io.intino.goros.modernizing.monet.util.StringUtil;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.CompositeFieldProperty;
import org.monet.metamodel.CompositeFieldPropertyBase;
import org.monet.metamodel.Definition;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.FormDefinitionBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.TaskDefinition;
import org.monet.metamodel.internal.LayoutDefinition;
import org.monet.metamodel.internal.LayoutElementBoxDefinition;
import org.monet.metamodel.internal.LayoutElementDefinition;
import org.monet.metamodel.internal.LayoutElementSectionDefinition;
import org.monet.metamodel.internal.Ref;

public class FormRenderer
extends NodeRenderer<FormDefinition> {
    public FormRenderer(Dictionary dictionary, Modernization modernization, FormDefinition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        super.write();
        this.writeCompositeFieldsTemplate();
    }

    @Override
    protected FrameBuilder buildFrame() {
        FrameBuilder result = super.buildFrame().add("formdefinition");
        this.addCompositeFieldsTemplates(result);
        return result;
    }

    @Override
    protected FrameBuilder viewFrame(NodeViewProperty viewProperty) {
        FrameBuilder result = this.baseViewFrame(viewProperty);
        this.addShow((FormDefinitionBase.FormViewProperty)viewProperty, result);
        this.addDisplayProvider((FormDefinitionBase.FormViewProperty)viewProperty, result);
        return result;
    }

    @Override
    protected boolean hasTemplate(NodeViewProperty viewProperty) {
        FormDefinitionBase.FormViewProperty.ShowProperty showProperty = ((FormDefinitionBase.FormViewProperty)viewProperty).getShow();
        if (showProperty.getField().size() > 0) {
            return true;
        }
        if (showProperty.getAttachments() != null) {
            return true;
        }
        if (showProperty.getRecentTask() != null) {
            return true;
        }
        if (showProperty.getLayout() != null) {
            return true;
        }
        if (showProperty.getRevisions() != null) {
            return true;
        }
        if (showProperty.getLocation() != null) {
            return true;
        }
        return showProperty.getLayoutExtended() != null;
    }

    @Override
    protected boolean isVisibleOnRevision(NodeViewProperty viewProperty) {
        FormDefinitionBase.FormViewProperty.ShowProperty showProperty = ((FormDefinitionBase.FormViewProperty)viewProperty).getShow();
        return showProperty.getLayout() != null || showProperty.getLayoutExtended() != null || showProperty.getAttachments() != null || showProperty.getField().size() > 0;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.monet.renderers.templates.konos.FormTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new FormTemplate();
    }

    private void writeCompositeFieldsTemplate() {
        ((FormDefinition)this.definition()).getCompositeFieldPropertyList().forEach(this::writeCompositeFieldTemplate);
    }

    private void writeCompositeFieldTemplate(CompositeFieldProperty field) {
        this.resetAddedDisplays();
        FrameBuilder viewFrame = this.compositeViewFrame(field, new FrameBuilder());
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + StringUtil.firstUpperCase(field.getName()) + "Template.java");
        this.writeFrame(file, new FormTemplate().render(viewFrame.toFrame()));
        field.getCompositeFieldPropertyList().forEach(this::writeCompositeFieldTemplate);
    }

    private void addCompositeFieldsTemplates(FrameBuilder builder) {
        ((FormDefinition)this.definition()).getCompositeFieldPropertyList().forEach(f -> this.addCompositeView((CompositeFieldProperty)f, builder));
    }

    private void addCompositeView(CompositeFieldProperty fieldProperty, FrameBuilder builder) {
        builder.add("compositeview", this.compositeViewFrame(fieldProperty, builder));
    }

    private FrameBuilder compositeViewFrame(CompositeFieldProperty fieldProperty, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("compositeview");
        FormDefinition definition = (FormDefinition)this.definition();
        result.add("definition", this.nameOf(definition));
        result.add("label", this.clean(fieldProperty.getLabel()));
        result.add("name", fieldProperty.getName());
        this.addDisplayProvider(fieldProperty, result);
        if (fieldProperty.isMultiple()) {
            result.add("implements", "io.intino.alexandria.ui.displays.components.editable.Editable");
            result.add("editable", new FrameBuilder("editable"));
        }
        this.addDisplayFor(fieldProperty, builder);
        this.addShow(fieldProperty, result);
        fieldProperty.getAllFieldPropertyList().forEach(f -> {
            if (f instanceof CompositeFieldProperty) {
                this.addCompositeView((CompositeFieldProperty)f, builder);
            }
            this.addField((FieldProperty)f, fieldProperty, null, result);
        });
        return result;
    }

    private FieldProperty fieldProperty(Ref ref, CompositeFieldProperty field) {
        return field.getAllFieldPropertyList().stream().filter(fd -> {
            String key = ref.getValue();
            return fd.getCode().equals(key) || fd.getName().equals(key);
        }).findFirst().orElse(null);
    }

    private FieldProperty fieldProperty(Ref ref) {
        return ((FormDefinition)this.definition()).getAllFieldPropertyList().stream().filter(fd -> {
            String key = ref.getValue();
            return fd.getCode().equals(key) || fd.getName().equals(key);
        }).findFirst().orElse(null);
    }

    private void addShow(FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        FormDefinitionBase.FormViewProperty.ShowProperty showProperty = viewProperty.getShow();
        FrameBuilder result = this.baseFrame().add("show");
        result.add(this.typeOf(showProperty));
        result.add("view", this.nameOf(viewProperty));
        result.add("definition", this.nameOf((Definition)this.definition()));
        if (showProperty.getRecentTask() != null) {
            this.addRecentTaskShow(viewProperty, showProperty, result);
        } else if (showProperty.getLayout() != null) {
            builder.add("updateFields", this.baseFrame().add("updateFields"));
            this.addLayoutShow(viewProperty, result);
        } else if (showProperty.getField().size() > 0) {
            builder.add("updateFields", this.baseFrame().add("updateFields"));
            this.addFieldShow(viewProperty, result);
        }
        builder.add("show", result);
    }

    private void addShow(CompositeFieldProperty field, FrameBuilder builder) {
        CompositeFieldPropertyBase.ViewProperty viewProperty = field.getView();
        CompositeFieldPropertyBase.ViewProperty.ShowProperty showProperty = viewProperty != null ? viewProperty.getShow() : null;
        FrameBuilder result = this.baseFrame().add("show").add("composite");
        result.add(this.typeOf(showProperty));
        result.add("view", this.nameOf((Definition)this.definition()));
        result.add("definition", this.nameOf((Definition)this.definition()));
        builder.add("updateFields", this.baseFrame().add("updateFields"));
        if (showProperty == null) {
            this.addFieldShow(field.getAllFieldPropertyList(), field, result);
        } else if (showProperty.getLayout() != null) {
            this.addLayoutShow(viewProperty, result);
        } else if (this.fields(showProperty).size() > 0) {
            this.addFieldShow(field, viewProperty, result);
        }
        builder.add("show", result);
    }

    private List<Ref> fields(CompositeFieldPropertyBase.ViewProperty.ShowProperty showProperty) {
        ArrayList<Ref> fieldList = showProperty.getField();
        LinkedHashMap result = new LinkedHashMap();
        fieldList.forEach(f -> result.put(f.getValue(), f));
        return new ArrayList<Ref>(result.values());
    }

    private void addDisplayProvider(CompositeFieldProperty fieldProperty, FrameBuilder builder) {
        this.resetAddedDisplays();
        if (!this.isDisplayProvider(fieldProperty)) {
            return;
        }
        FrameBuilder result = new FrameBuilder("displayProvider");
        List<FieldProperty> fieldList = fieldProperty.getAllFieldPropertyList().stream().filter(field -> field.isComposite() || field.isNode()).collect(Collectors.toList());
        fieldList.forEach(f -> this.addDisplayFor((FieldProperty)f, result));
        builder.add("implements", "io.intino.goros.unit.box.ui.DisplayProvider");
        builder.add("displayProvider", result);
    }

    private void addDisplayProvider(FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        this.resetAddedDisplays();
        if (!this.isDisplayProvider(viewProperty)) {
            return;
        }
        FrameBuilder result = new FrameBuilder("displayProvider");
        List<FieldProperty> fieldList = viewProperty.getShow().getField().stream().map(this::fieldProperty).filter(field -> field.isComposite() || field.isNode()).collect(Collectors.toList());
        fieldList.forEach(f -> this.addDisplayFor((FieldProperty)f, result));
        builder.add("implements", "io.intino.goros.unit.box.ui.DisplayProvider");
        builder.add("displayProvider", result);
    }

    private boolean isDisplayProvider(FormDefinitionBase.FormViewProperty viewProperty) {
        FormDefinitionBase.FormViewProperty.ShowProperty showProperty = viewProperty.getShow();
        if (showProperty.getField().size() <= 0) {
            return false;
        }
        return showProperty.getField().stream().anyMatch(ref -> this.fieldProperty((Ref)ref).isComposite() || this.fieldProperty((Ref)ref).isNode());
    }

    private boolean isDisplayProvider(CompositeFieldProperty fieldProperty) {
        return fieldProperty.getAllFieldPropertyList().stream().anyMatch(field -> field.isComposite() || field.isNode());
    }

    private void addRecentTaskShow(FormDefinitionBase.FormViewProperty viewProperty, FormDefinitionBase.FormViewProperty.ShowProperty showProperty, FrameBuilder builder) {
        ArrayList<Ref> taskList = showProperty.getRecentTask().getTask();
        List<TaskDefinition> definitionList = taskList.size() <= 0 ? this.findTaskDefinitionsWith((Definition)this.definition()) : taskList.stream().map(ref -> this.dictionary.getTaskDefinition(ref.getValue())).collect(Collectors.toList());
        definitionList.forEach(d -> this.addRecentTaskType((TaskDefinition)d, builder));
    }

    private void addFieldShow(FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        viewProperty.getShow().getField().forEach(ref -> this.addField(this.fieldProperty((Ref)ref), null, viewProperty, builder));
    }

    private void addFieldShow(CompositeFieldProperty field, CompositeFieldPropertyBase.ViewProperty viewProperty, FrameBuilder builder) {
        this.fields(viewProperty.getShow()).forEach(ref -> this.addField(this.fieldProperty((Ref)ref, field), field, null, builder));
    }

    private void addFieldShow(List<FieldProperty> fieldList, CompositeFieldProperty compositeField, FrameBuilder builder) {
        fieldList.forEach(field -> this.addField((FieldProperty)field, compositeField, null, builder));
    }

    private void addLayoutShow(FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        this.addLayoutShow(this.dictionary.getLayoutDefinition(viewProperty.getShow().getLayout()), viewProperty, builder);
    }

    private void addLayoutShow(CompositeFieldPropertyBase.ViewProperty viewProperty, FrameBuilder builder) {
        this.addLayoutShow(this.dictionary.getLayoutDefinition(viewProperty.getShow().getLayout()), null, builder);
    }

    private void addLayoutShow(LayoutDefinition definition, FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        String width = definition.getWidth();
        String height = definition.getHeight();
        if (width == null && height == null) {
            builder.add("relativeFacet", this.sizeFacetFrame("relative", "90", null));
        } else if (this.isUnitRelative(width) || this.isUnitRelative(height)) {
            builder.add("relativeFacet", this.relativeFacetFrame(definition));
        } else {
            builder.add("absoluteFacet", this.absoluteFacetFrame(definition));
        }
        builder.add("width", definition.getWidth() != null ? definition.getWidth() : "100%");
        this.rowsOf(definition.getElements()).forEach(row -> this.addLayoutRow((List<LayoutElementDefinition>)row, null, viewProperty, builder));
    }

    private List<List<LayoutElementDefinition>> rowsOf(List<LayoutElementDefinition> elements) {
        ArrayList<List<LayoutElementDefinition>> result = new ArrayList<List<LayoutElementDefinition>>();
        int index = -1;
        for (LayoutElementDefinition element : elements) {
            if (element.isBreak() || index == -1) {
                ++index;
            }
            if (result.size() <= index) {
                result.add(new ArrayList());
            }
            if (element.isBreak()) continue;
            ((List)result.get(index)).add(element);
        }
        return result;
    }

    private void addLayoutRow(List<LayoutElementDefinition> row, CompositeFieldProperty composite, FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("layoutRow");
        row.forEach(e -> this.addLayoutElement((LayoutElementDefinition)e, composite, viewProperty, result));
        builder.add("row", result);
    }

    private void addLayoutElement(LayoutElementDefinition element, CompositeFieldProperty composite, FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        FrameBuilder result = this.baseFrame().add("layoutElement");
        result.add(this.typeOf(element));
        this.addLayoutSizeToElement(element, result);
        if (element.isSection()) {
            LayoutElementSectionDefinition section = (LayoutElementSectionDefinition)element;
            result.add("label", this.clean(section.getLabel()));
            this.rowsOf(section.getElements()).forEach(r -> this.addLayoutRow((List<LayoutElementDefinition>)r, composite, viewProperty, result));
        } else if (element.isBox()) {
            LayoutElementBoxDefinition box = (LayoutElementBoxDefinition)element;
            FormDefinition definition = (FormDefinition)this.definition();
            FieldProperty field = definition.getField(box.getLink());
            if (field != null) {
                result.add("field", this.renderer(definition, definition.getField(box.getLink()), composite).view(viewProperty).buildFrame().add("definition", this.nameOf(definition)));
            }
        }
        builder.add("element", result);
    }

    private void addLayoutSizeToElement(LayoutElementDefinition element, FrameBuilder builder) {
        float width = element.getWidth();
        float height = element.getHeight();
        if (width == 0.0f && height == 0.0f) {
            return;
        }
        boolean relative = this.isUnitRelative(element.getHeightUnit()) || this.isUnitRelative(element.getWidthUnit());
        FrameBuilder result = this.sizeFacetFrame(relative ? "relative" : "absolute", this.toString(element.getWidth()), this.toString(element.getHeight()));
        builder.add(relative ? "relativeFacet" : "absoluteFacet", result);
    }

    private boolean isUnitRelative(String unit) {
        return unit != null && (unit.isEmpty() || unit.contains("%"));
    }

    private String toString(float value) {
        return value != 0.0f ? String.valueOf(value) : null;
    }

    private String typeOf(LayoutElementDefinition element) {
        if (element.isSection()) {
            return "section";
        }
        if (element.isSpace()) {
            return "space";
        }
        return "box";
    }

    private FrameBuilder absoluteFacetFrame(LayoutDefinition definition) {
        return this.sizeFacetFrame("absolute", definition.getWidth(), definition.getHeight());
    }

    private FrameBuilder relativeFacetFrame(LayoutDefinition definition) {
        return this.sizeFacetFrame("relative", definition.getWidth(), definition.getHeight());
    }

    private FrameBuilder sizeFacetFrame(String type, String width, String height) {
        FrameBuilder result = this.baseFrame().add(type + "Facet");
        if (width != null) {
            result.add("width", this.clean(width));
        }
        if (height != null) {
            result.add("height", this.clean(height));
        }
        return result;
    }

    private String clean(String size) {
        return size.replace("px", "").replace("%", "");
    }

    private void addField(FieldProperty fieldProperty, CompositeFieldProperty composite, FormDefinitionBase.FormViewProperty viewProperty, FrameBuilder builder) {
        builder.add("field", this.renderer((FormDefinition)this.definition(), fieldProperty, composite).view(viewProperty).buildFrame().add("definition", this.nameOf((Definition)this.definition())));
    }
}

