/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.modernizing.monet.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.monet.metamodel.CatalogDefinition;
import org.monet.metamodel.CollectionDefinition;
import org.monet.metamodel.ContainerDefinition;
import org.monet.metamodel.DashboardDefinition;
import org.monet.metamodel.DatastoreBuilderDefinition;
import org.monet.metamodel.DatastoreDefinition;
import org.monet.metamodel.DatastoreDefinitionBase;
import org.monet.metamodel.Definition;
import org.monet.metamodel.DesktopDefinition;
import org.monet.metamodel.Distribution;
import org.monet.metamodel.DocumentDefinition;
import org.monet.metamodel.ExporterDefinition;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.GlossaryDefinition;
import org.monet.metamodel.ImporterDefinition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.JobDefinition;
import org.monet.metamodel.KpiDefinition;
import org.monet.metamodel.MeasureUnitDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.Project;
import org.monet.metamodel.RoleDefinition;
import org.monet.metamodel.ServiceDefinition;
import org.monet.metamodel.SourceDefinition;
import org.monet.metamodel.TaskDefinition;
import org.monet.metamodel.ThesaurusDefinition;
import org.monet.metamodel.interfaces.IsInitiable;
import org.monet.metamodel.interfaces.Language;
import org.monet.metamodel.internal.DescriptorDefinition;
import org.monet.metamodel.internal.LayoutDefinition;
import org.monet.metamodel.internal.Ref;
import org.monet.metamodel.internal.TaskOrderDefinition;
import org.monet.space.kernel.bpi.java.locator.PackageReader;
import org.monet.space.kernel.model.BusinessModelClassLoader;
import org.monet.space.kernel.model.Replacer;

public class Dictionary
extends org.monet.metamodel.Dictionary {
    private HashMap<String, NodeDefinition> nodesMap;
    private HashMap<String, ContainerDefinition> containersMap;
    private ArrayList<ContainerDefinition> containersList;
    private HashMap<String, DesktopDefinition> desktopsMap;
    private ArrayList<DesktopDefinition> desktopsList;
    private HashMap<String, CollectionDefinition> collectionsMap;
    private ArrayList<CollectionDefinition> collectionsList;
    private HashMap<String, FormDefinition> formsMap;
    private ArrayList<FormDefinition> formsList;
    private HashMap<String, DocumentDefinition> documentsMap;
    private ArrayList<DocumentDefinition> documentsList;
    private HashMap<String, CatalogDefinition> catalogsMap;
    private ArrayList<CatalogDefinition> catalogsList;
    private HashMap<String, TaskDefinition> servicesMap;
    private HashMap<String, JobDefinition> jobsMap;
    private HashMap<String, TaskDefinition> taskMap;
    private ArrayList<TaskDefinition> taskList;
    private HashMap<String, IndexDefinition> indexMap;
    private ArrayList<IndexDefinition> indexList;
    private HashMap<String, SourceDefinition> sourceMap;
    private ArrayList<SourceDefinition> sourceList;
    private HashMap<String, ThesaurusDefinition> thesaurusMap;
    private ArrayList<ThesaurusDefinition> thesaurusList;
    private HashMap<String, GlossaryDefinition> glossaryMap;
    private ArrayList<GlossaryDefinition> glossaryList;
    private HashMap<String, MeasureUnitDefinition> measureUnitMap;
    private ArrayList<MeasureUnitDefinition> measureUnitList;
    private HashMap<String, KpiDefinition> kpiMap;
    private ArrayList<KpiDefinition> kpiList;
    private ArrayList<ImporterDefinition> importersList;
    private HashMap<String, ImporterDefinition> importersMap;
    private HashMap<String, ExporterDefinition> exportersMap;
    private HashMap<String, DashboardDefinition> dashboardMap;
    private ArrayList<DashboardDefinition> dashboardList;
    private HashMap<String, Class<?>> indicatorFormulaClassMap;
    private HashMap<String, Class<?>> taxonomyClassifierClassMap;
    private HashMap<String, DatastoreDefinition> datastoreMap;
    private ArrayList<DatastoreDefinition> datastoreList;
    private HashMap<String, DatastoreDefinitionBase.DimensionProperty> dimensionMap;
    private HashMap<String, DatastoreDefinitionBase.CubeProperty> cubeMap;
    private HashMap<String, Definition> definitionMap;
    private ArrayList<Definition> definitionList;
    private ArrayList<NodeDefinition> singletonDefinitionList;
    private HashMap<String, RoleDefinition> rolesMap;
    private ArrayList<RoleDefinition> rolesList;
    private ArrayList<String> rolesNames;
    private HashMap<String, FieldProperty> fieldsMap;
    private HashMap<String, DatastoreBuilderDefinition> datastoreBuilderMap;
    private ArrayList<DatastoreBuilderDefinition> datastoreBuilderList;
    private HashMap<String, LayoutDefinition> layoutDefinitionMap;
    private HashMap<String, ArrayList<DatastoreBuilderDefinition>> datastoreBuilders = new HashMap();
    private List<NodeDefinition> environments;
    private Language defaultLanguage;
    private HashMap<String, Language> languages = new HashMap();
    public static final String DICTIONARY = "Dictionary";
    private HashMap<String, String> preDependencyMap = new HashMap();
    private HashMap<String, ArrayList<String>> dependencyMap = new HashMap();
    private HashMap<String, String> defineMap = new HashMap();
    private ArrayList<Replacer> replacersList = new ArrayList();
    private HashMap<String, ArrayList<String>> ontologiesMap = new HashMap();
    private HashMap<String, ArrayList<ThesaurusDefinition>> selfGeneratedThesaurus = new HashMap();
    private String basePackage = null;
    private String businessModelDir;

    public Dictionary() {
        this.nodesMap = new HashMap();
        this.containersMap = new HashMap();
        this.containersList = new ArrayList();
        this.desktopsMap = new HashMap();
        this.desktopsList = new ArrayList();
        this.collectionsMap = new HashMap();
        this.collectionsList = new ArrayList();
        this.formsMap = new HashMap();
        this.formsList = new ArrayList();
        this.documentsMap = new HashMap();
        this.documentsList = new ArrayList();
        this.catalogsMap = new HashMap();
        this.catalogsList = new ArrayList();
        this.servicesMap = new HashMap();
        this.jobsMap = new HashMap();
        this.taskMap = new HashMap();
        this.taskList = new ArrayList();
        this.indexMap = new HashMap();
        this.indexList = new ArrayList();
        this.sourceMap = new HashMap();
        this.sourceList = new ArrayList();
        this.thesaurusMap = new HashMap();
        this.thesaurusList = new ArrayList();
        this.glossaryMap = new HashMap();
        this.glossaryList = new ArrayList();
        this.measureUnitList = new ArrayList();
        this.measureUnitMap = new HashMap();
        this.dashboardList = new ArrayList();
        this.dashboardMap = new HashMap();
        this.indicatorFormulaClassMap = new HashMap();
        this.taxonomyClassifierClassMap = new HashMap();
        this.datastoreList = new ArrayList();
        this.datastoreMap = new HashMap();
        this.dimensionMap = new HashMap();
        this.cubeMap = new HashMap();
        this.kpiList = new ArrayList();
        this.kpiMap = new HashMap();
        this.importersList = new ArrayList();
        this.importersMap = new HashMap();
        this.exportersMap = new HashMap();
        this.environments = new ArrayList<NodeDefinition>();
        this.definitionMap = new HashMap();
        this.definitionList = new ArrayList();
        this.singletonDefinitionList = new ArrayList();
        this.rolesMap = new HashMap();
        this.rolesList = new ArrayList();
        this.rolesNames = new ArrayList();
        this.fieldsMap = new HashMap();
        this.datastoreBuilderMap = new HashMap();
        this.datastoreBuilderList = new ArrayList();
        this.layoutDefinitionMap = new HashMap();
    }

    private <T> ArrayList<T> getDefinition(String key, HashMap<String, T> definitionMap) {
        ArrayList<String> implementers;
        ArrayList<T> definitions = new ArrayList<T>();
        Definition mainDefinition = this.definitionMap.get(key.toLowerCase());
        String mainDefinitionName = null;
        if (mainDefinition != null) {
            mainDefinitionName = mainDefinition.getName().toLowerCase();
        }
        if ((implementers = this.dependencyMap.get(mainDefinitionName)) == null) {
            throw new RuntimeException("Business model definition not found");
        }
        if (implementers.size() == 0) {
            throw new RuntimeException("Business model definition implementation not found");
        }
        for (String implementerKey : implementers) {
            T definition = definitionMap.get(implementerKey.toLowerCase());
            definitions.add(definition);
        }
        return definitions;
    }

    public Collection<Definition> getAllDefinitions() {
        return this.definitionList;
    }

    public String getDefinitionCode(String key) {
        Definition definition = this.definitionMap.get(key.toLowerCase());
        if (definition == null) {
            return null;
        }
        return definition.getCode();
    }

    public NodeDefinition getNodeDefinition(String key) {
        return this.getDefinition(key, this.nodesMap).get(0);
    }

    public ArrayList<NodeDefinition> getAllImplementersOfNodeDefinition(String key) {
        return this.getDefinition(key, this.nodesMap);
    }

    public FormDefinition getFormDefinition(String key) {
        return this.getDefinition(key, this.formsMap).get(0);
    }

    public Boolean isFormDefinition(String key) {
        return this.formsMap.containsKey(key.toLowerCase());
    }

    public Boolean isCatalogDefinition(String key) {
        return this.catalogsMap.containsKey(key.toLowerCase());
    }

    public FieldProperty getFormFieldDefinition(String nodeKey, String fieldKey) {
        FormDefinition formDefinition = this.getFormDefinition(nodeKey);
        return formDefinition.getField(fieldKey);
    }

    public List<NodeDefinition> getEnvironmentDefinitionList() {
        return this.environments;
    }

    public HashMap<String, ArrayList<NodeDefinition>> getEnvironmentDefinitionListByRole() {
        HashMap<String, ArrayList<NodeDefinition>> environmentDefinitions = new HashMap<String, ArrayList<NodeDefinition>>();
        List<NodeDefinition> environmentDefinitionList = this.getEnvironmentDefinitionList();
        for (RoleDefinition roleDefinition : this.getRoleDefinitionList()) {
            String roleCode = roleDefinition.getCode();
            ArrayList<NodeDefinition> environmentDefinitionWithRole = new ArrayList<NodeDefinition>();
            environmentDefinitions.put(roleCode, environmentDefinitionWithRole);
            block1: for (NodeDefinition environmentDefinition : environmentDefinitionList) {
                if (environmentDefinition.isAbstract()) continue;
                List<Ref> roleRefs = environmentDefinition.getRoles();
                for (Ref roleRef : roleRefs) {
                    String environmentRoleCode = this.getDefinitionCode(roleRef.getValue());
                    if (!environmentRoleCode.equals(roleCode)) continue;
                    environmentDefinitionWithRole.add(environmentDefinition);
                    continue block1;
                }
            }
        }
        return environmentDefinitions;
    }

    public HashMap<String, ArrayList<DashboardDefinition>> getDashboardDefinitionListByRole() {
        HashMap<String, ArrayList<DashboardDefinition>> dashboardDefinitions = new HashMap<String, ArrayList<DashboardDefinition>>();
        List<DashboardDefinition> dashboardDefinitionList = this.getDashboardDefinitionList();
        for (RoleDefinition roleDefinition : this.getRoleDefinitionList()) {
            String roleCode = roleDefinition.getCode();
            ArrayList<DashboardDefinition> dashboardDefinitionWithRole = new ArrayList<DashboardDefinition>();
            dashboardDefinitions.put(roleCode, dashboardDefinitionWithRole);
            block1: for (DashboardDefinition dashboardDefinition : dashboardDefinitionList) {
                if (dashboardDefinition.isAbstract() || dashboardDefinition.getFor() == null) continue;
                ArrayList<Ref> roleRefs = dashboardDefinition.getFor().getRole();
                for (Ref roleRef : roleRefs) {
                    String dashboardRoleCode = this.getDefinitionCode(roleRef.getValue());
                    if (!dashboardRoleCode.equals(roleCode)) continue;
                    dashboardDefinitionWithRole.add(dashboardDefinition);
                    continue block1;
                }
            }
        }
        return dashboardDefinitions;
    }

    public List<NodeDefinition> getSingletonDefinitionList() {
        return this.singletonDefinitionList;
    }

    public DesktopDefinition getDesktopDefinition(String key) {
        return this.getDefinition(key, this.desktopsMap).get(0);
    }

    public List<DesktopDefinition> getDesktopDefinitionList() {
        return this.desktopsList;
    }

    public List<ContainerDefinition> getContainerDefinitionList() {
        return this.containersList;
    }

    public List<CollectionDefinition> getCollectionDefinitionList() {
        return this.collectionsList;
    }

    public List<CatalogDefinition> getCatalogDefinitionList() {
        return this.catalogsList;
    }

    public List<FormDefinition> getFormDefinitionList() {
        return this.formsList;
    }

    public DocumentDefinition getDocumentDefinition(String key) {
        return this.getDefinition(key, this.documentsMap).get(0);
    }

    public List<DocumentDefinition> getDocumentDefinitionList() {
        return this.documentsList;
    }

    public CollectionDefinition getCollectionDefinition(String key) {
        return this.getDefinition(key, this.collectionsMap).get(0);
    }

    public CatalogDefinition getCatalogDefinition(String key) {
        return this.getDefinition(key, this.catalogsMap).get(0);
    }

    public TaskDefinition getTaskDefinitionByServiceName(String key) {
        return this.servicesMap.get(key);
    }

    public Collection<TaskDefinition> getTaskDefinitionsWithServiceName() {
        return this.servicesMap.values();
    }

    public Collection<JobDefinition> getJobDefinitions() {
        return this.jobsMap.values();
    }

    public TaskDefinition getTaskDefinition(String key) {
        return this.getDefinition(key, this.taskMap).get(0);
    }

    public IndexDefinition getIndexDefinition(String key) {
        if (key.equals("td")) {
            return new DescriptorDefinition();
        }
        return this.getDefinition(key, this.indexMap).get(0);
    }

    public Collection<IndexDefinition> getIndexDefinitionList() {
        return this.indexList;
    }

    public ArrayList<ThesaurusDefinition> getThesaurusGeneratedByIndex(IndexDefinition definition) {
        return this.selfGeneratedThesaurus.get(definition.getCode());
    }

    public List<ImporterDefinition> getImporterDefinitionList() {
        return this.importersList;
    }

    public ImporterDefinition getImporterDefinition(String key) {
        return this.getDefinition(key, this.importersMap).get(0);
    }

    public ExporterDefinition getExporterDefinition(String key) {
        return this.getDefinition(key, this.exportersMap).get(0);
    }

    public List<TaskDefinition> getTaskDefinitionList() {
        return this.taskList;
    }

    public List<ThesaurusDefinition> getThesaurusDefinitionList() {
        return this.thesaurusList;
    }

    public Map<String, SourceDefinition> getSourceDefinitionMap() {
        return this.sourceMap;
    }

    public List<SourceDefinition> getSourceDefinitionList() {
        return this.sourceList;
    }

    public Map<String, ThesaurusDefinition> getThesaurusDefinitionMap() {
        return this.thesaurusMap;
    }

    public List<GlossaryDefinition> getGlossaryDefinitionList() {
        return this.glossaryList;
    }

    public Map<String, GlossaryDefinition> getGlossaryDefinitionMap() {
        return this.glossaryMap;
    }

    public List<MeasureUnitDefinition> getMeasureUnitDefinitionList() {
        return this.measureUnitList;
    }

    public Map<String, MeasureUnitDefinition> getMeasureUnitDefinitionMap() {
        return this.measureUnitMap;
    }

    public MeasureUnitDefinition getMeasureUnitDefinition(String key) {
        return this.getDefinition(key, this.measureUnitMap).get(0);
    }

    public Map<String, FieldProperty> getFieldDefinitionMap() {
        return this.fieldsMap;
    }

    public boolean existsFieldDefinition(String key) {
        return this.fieldsMap.containsKey(key);
    }

    public FieldProperty getFieldDefinition(String key) {
        if (!this.fieldsMap.containsKey(key)) {
            return null;
        }
        return this.fieldsMap.get(key);
    }

    public List<DashboardDefinition> getDashboardDefinitionList() {
        return this.dashboardList;
    }

    public Map<String, DashboardDefinition> getDashboardDefinitionMap() {
        return this.dashboardMap;
    }

    public DashboardDefinition getDashboardDefinition(String key) {
        return this.getDefinition(key, this.dashboardMap).get(0);
    }

    public Class<?> getDashboardIndicatorFormulaClass(DashboardDefinition definition, String indicatorCode) {
        return this.indicatorFormulaClassMap.get(indicatorCode);
    }

    public InputStream getDashboardIndicatorFormulaClassAsStream(DashboardDefinition definition, String indicatorCode) {
        return null;
    }

    public Class<?> getDashboardTaxonomyClassifierClass(DashboardDefinition definition, String taxonomyCode) {
        return this.taxonomyClassifierClassMap.get(taxonomyCode);
    }

    public InputStream getDashboardTaxonomyClassifierClassAsStream(DashboardDefinition definition, String taxonomyCode) {
        return null;
    }

    public List<DatastoreDefinition> getDatastoreDefinitionList() {
        return this.datastoreList;
    }

    public Map<String, DatastoreDefinition> getDatastoreDefinitionMap() {
        return this.datastoreMap;
    }

    public DatastoreDefinition getDatastoreDefinition(String key) {
        return this.getDefinition(key, this.datastoreMap).get(0);
    }

    public DatastoreDefinitionBase.DimensionProperty getDimensionDefinition(String key) {
        if (this.dimensionMap.containsKey(key)) {
            return this.dimensionMap.get(key);
        }
        return this.dimensionMap.get(key.toLowerCase());
    }

    public DatastoreDefinitionBase.CubeProperty getCubeDefinition(String key) {
        if (this.cubeMap.containsKey(key)) {
            return this.cubeMap.get(key);
        }
        return this.cubeMap.get(key.toLowerCase());
    }

    public SourceDefinition getSourceDefinition(String key) {
        return this.getDefinition(key, this.sourceMap).get(0);
    }

    public ThesaurusDefinition getThesaurusDefinition(String key) {
        return this.getDefinition(key, this.thesaurusMap).get(0);
    }

    public GlossaryDefinition getGlossaryDefinition(String key) {
        return this.getDefinition(key, this.glossaryMap).get(0);
    }

    public RoleDefinition getRoleDefinition(String key) {
        return this.getDefinition(key, this.rolesMap).get(0);
    }

    public boolean existsRoleDefinition(String key) {
        return this.rolesMap.containsKey(key.toLowerCase());
    }

    public ArrayList<RoleDefinition> getRoleDefinitionList() {
        return this.rolesList;
    }

    public List<String> getRolesNames() {
        return this.rolesNames;
    }

    public ArrayList<DatastoreBuilderDefinition> getDatastoreBuildersForNode(String nodeKey) {
        if (!this.datastoreBuilders.containsKey(nodeKey)) {
            return new ArrayList<DatastoreBuilderDefinition>();
        }
        return this.datastoreBuilders.get(nodeKey);
    }

    public ArrayList<DatastoreBuilderDefinition> getDatastoreBuilders() {
        return this.datastoreBuilderList;
    }

    public DatastoreBuilderDefinition getDatastoreBuilder(String key) {
        return this.datastoreBuilderMap.get(key.toLowerCase());
    }

    public Definition getDefinition(String key) {
        return this.getDefinition(key, this.definitionMap).get(0);
    }

    public boolean existsDefinition(String key) {
        return this.definitionMap.containsKey(key.toLowerCase());
    }

    public boolean reset(Distribution distribution, Project project) {
        this.defineMap.clear();
        this.defineMap.putAll(project.getDefineMap());
        this.defineMap.putAll(distribution.getDefineMap());
        return true;
    }

    public String getVariable(String varName) {
        return this.defineMap.get(varName);
    }

    public LayoutDefinition getLayoutDefinition(String key) {
        LayoutDefinition layoutDefinition = null;
        if (this.layoutDefinitionMap.containsKey(key)) {
            return this.layoutDefinitionMap.get(key);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(LayoutDefinition.class);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File layoutFile = new File(this.businessModelDir + File.separator + "res" + File.separator + key);
            layoutDefinition = (LayoutDefinition)unmarshaller.unmarshal(layoutFile);
            this.layoutDefinitionMap.put(key, layoutDefinition);
        }
        catch (JAXBException exception) {
            Logger.error(exception);
        }
        return layoutDefinition;
    }

    private <T extends Definition> void addDefinition(Definition definition, HashMap<String, T> definitionMap, ArrayList<T> definitionList) {
        String code = definition.getCode().toLowerCase();
        String name = definition.getName().toLowerCase();
        if (definitionMap.containsKey(name)) {
            return;
        }
        definitionMap.put(code, definition);
        definitionMap.put(name, definition);
        if (definition instanceof NodeDefinition) {
            boolean isEnvironment;
            NodeDefinition nodeDefinition = (NodeDefinition)definition;
            this.nodesMap.put(code, nodeDefinition);
            this.nodesMap.put(name, nodeDefinition);
            boolean bl = isEnvironment = nodeDefinition instanceof DesktopDefinition || nodeDefinition instanceof ContainerDefinition && ((ContainerDefinition)nodeDefinition).isEnvironment();
            if (isEnvironment && !nodeDefinition.isAbstract()) {
                this.environments.add(nodeDefinition);
            }
            if (nodeDefinition.isSingleton() && !nodeDefinition.isAbstract()) {
                this.singletonDefinitionList.add(nodeDefinition);
            }
        }
        if (definition instanceof RoleDefinition) {
            this.rolesNames.add(name);
        }
        if (definitionList != null) {
            definitionList.add(definition);
        }
        if (definition instanceof DatastoreDefinition) {
            for (DatastoreDefinitionBase.DimensionProperty dimensionDefinition : ((DatastoreDefinition)definition).getDimensionList()) {
                this.dimensionMap.put(name + "." + dimensionDefinition.getName().toLowerCase(), dimensionDefinition);
                this.dimensionMap.put(dimensionDefinition.getCode(), dimensionDefinition);
            }
            for (DatastoreDefinitionBase.CubeProperty cubeDefinition : ((DatastoreDefinition)definition).getCubeList()) {
                this.cubeMap.put(name + "." + cubeDefinition.getName().toLowerCase(), cubeDefinition);
                this.cubeMap.put(cubeDefinition.getCode(), cubeDefinition);
            }
        }
        this.definitionMap.put(code, definition);
        this.definitionMap.put(name, definition);
        this.definitionList.add(definition);
    }

    private void prepareBuilders() {
        this.prepareDatastoreBuilders();
    }

    private void prepareDatastoreBuilders() {
        for (DatastoreBuilderDefinition builderDefinition : this.datastoreBuilderList) {
            String nodeDefinitionKey = builderDefinition.getSource().getValue();
            for (NodeDefinition nodeDefinition : this.getDefinition(nodeDefinitionKey, this.nodesMap)) {
                ArrayList<DatastoreBuilderDefinition> builders = this.datastoreBuilders.get(nodeDefinition.getName());
                if (builders == null) {
                    builders = new ArrayList();
                    this.datastoreBuilders.put(nodeDefinition.getName(), builders);
                }
                builders.add(builderDefinition);
            }
        }
    }

    @Override
    public void replace(Class<? extends Definition> clazz, String name, String replacedName) {
        this.replacersList.add(new Replacer(clazz, name, replacedName));
        this.register(clazz, name, replacedName);
    }

    @Override
    public void register(Class<? extends Definition> clazz, String name, String parentName) {
        try {
            Definition definition = clazz.newInstance();
            if (definition instanceof ContainerDefinition) {
                this.addDefinition(definition, this.containersMap, this.containersList);
            } else if (definition instanceof DesktopDefinition) {
                this.addDefinition(definition, this.desktopsMap, this.desktopsList);
            } else if (definition instanceof CollectionDefinition) {
                this.addDefinition(definition, this.collectionsMap, this.collectionsList);
            } else if (definition instanceof FormDefinition) {
                this.addDefinition(definition, this.formsMap, this.formsList);
            } else if (definition instanceof DocumentDefinition) {
                this.addDefinition(definition, this.documentsMap, this.documentsList);
            } else if (definition instanceof CatalogDefinition) {
                this.addDefinition(definition, this.catalogsMap, this.catalogsList);
            } else if (definition instanceof TaskDefinition) {
                this.addDefinition(definition, this.taskMap, this.taskList);
                if (definition instanceof ServiceDefinition) {
                    this.servicesMap.put(definition.getName(), (TaskDefinition)definition);
                } else if (definition instanceof JobDefinition) {
                    this.jobsMap.put(definition.getName(), (JobDefinition)definition);
                }
            } else if (definition instanceof IndexDefinition) {
                this.addDefinition(definition, this.indexMap, this.indexList);
            } else if (definition instanceof ThesaurusDefinition) {
                this.addDefinition(definition, this.thesaurusMap, this.thesaurusList);
                this.sourceMap.put(definition.getCode().toLowerCase(), (SourceDefinition)definition);
                this.sourceMap.put(definition.getName().toLowerCase(), (SourceDefinition)definition);
                this.sourceList.add((SourceDefinition)definition);
            } else if (definition instanceof GlossaryDefinition) {
                this.addDefinition(definition, this.glossaryMap, this.glossaryList);
                this.sourceMap.put(definition.getCode().toLowerCase(), (SourceDefinition)definition);
                this.sourceMap.put(definition.getName().toLowerCase(), (SourceDefinition)definition);
                this.sourceList.add((SourceDefinition)definition);
            } else if (definition instanceof KpiDefinition) {
                this.addDefinition(definition, this.kpiMap, this.kpiList);
            } else if (definition instanceof MeasureUnitDefinition) {
                this.addDefinition(definition, this.measureUnitMap, this.measureUnitList);
            } else if (definition instanceof DashboardDefinition) {
                this.addDefinition(definition, this.dashboardMap, this.dashboardList);
            } else if (definition instanceof DatastoreDefinition) {
                this.addDefinition(definition, this.datastoreMap, this.datastoreList);
            } else if (definition instanceof KpiDefinition) {
                this.addDefinition(definition, this.kpiMap, this.kpiList);
            } else if (definition instanceof ImporterDefinition) {
                this.addDefinition(definition, this.importersMap, this.importersList);
            } else if (definition instanceof ExporterDefinition) {
                this.addDefinition(definition, this.exportersMap, null);
            } else if (definition instanceof RoleDefinition) {
                this.addDefinition(definition, this.rolesMap, this.rolesList);
            } else if (definition instanceof DatastoreBuilderDefinition) {
                this.addDefinition(definition, this.datastoreBuilderMap, this.datastoreBuilderList);
            }
            if (definition instanceof IsInitiable) {
                ((IsInitiable)((Object)definition)).init();
            }
            if (definition instanceof FormDefinition) {
                FormDefinition formDefinition = (FormDefinition)definition;
                this.fieldsMap.putAll(formDefinition.getFields());
            }
            this.preDependencyMap.put(name.toLowerCase(), parentName != null ? parentName.toLowerCase() : null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerDashboardIndicatorFormulaClass(Class<?> clazz, String indicatorCode) {
        this.indicatorFormulaClassMap.put(indicatorCode, clazz);
    }

    @Override
    public void registerDashboardTaxonomyClassifierClass(Class<?> clazz, String taxonomyCode) {
        this.taxonomyClassifierClassMap.put(taxonomyCode, clazz);
    }

    private void registerSelfGeneratedThesaurus(ThesaurusDefinition definition) {
        if (definition.isSelfGenerated() && definition.getSelfGenerated().getFromIndex() == null) {
            return;
        }
        IndexDefinition indexDefinition = this.getIndexDefinition(definition.getSelfGenerated().getFromIndex().getIndex().getValue());
        ArrayList<ThesaurusDefinition> indexThesaurus = this.selfGeneratedThesaurus.get(indexDefinition.getCode());
        if (indexThesaurus == null) {
            indexThesaurus = new ArrayList();
            this.selfGeneratedThesaurus.put(indexDefinition.getCode(), indexThesaurus);
        }
        indexThesaurus.add(definition);
    }

    @Override
    public void registerLanguage(Class<? extends Language> clazz, String localeCode) {
        try {
            Language language = clazz.newInstance();
            language.init(localeCode);
            this.addLanguage(localeCode, language);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<String> getLanguages() {
        return this.languages.keySet();
    }

    private void checkLanguagesRegistered() {
        Language language;
        if (!this.languages.containsKey("es")) {
            language = new Language();
            language.init("es");
            this.addLanguage("es", language);
        }
        if (!this.languages.containsKey("en")) {
            language = new Language();
            language.init("en");
            this.addLanguage("en", language);
        }
    }

    private void addLanguage(String localeCode, Language language) {
        if (localeCode.equals("default")) {
            if (this.defaultLanguage == null) {
                this.defaultLanguage = language;
            } else {
                this.defaultLanguage.merge(language);
            }
        } else {
            Language currentInstance = this.languages.get(localeCode);
            if (currentInstance == null) {
                this.languages.put(localeCode, language);
            } else {
                currentInstance.merge(language);
            }
        }
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Language getLanguage(String localeCode) {
        return this.languages.get(localeCode);
    }

    public void initialize(String businessModelDir) {
        String classesDir = businessModelDir + File.separator + "classes";
        String librariesDir = businessModelDir + File.separator + "classes_libraries";
        PackageReader reader = new PackageReader(classesDir);
        BusinessModelClassLoader classLoader = new BusinessModelClassLoader(classesDir, librariesDir);
        this.businessModelDir = businessModelDir;
        try {
            this.clean();
            for (String classname : reader.read()) {
                try {
                    Class.forName(classname, true, classLoader);
                }
                catch (Exception e) {
                    Logger.error(String.format("Could not register definition class in dictionary: %s", classname));
                    throw new RuntimeException(String.format("Could not register definition class in dictionary: %s", classname));
                }
            }
            this.checkLanguagesRegistered();
            this.register(TaskOrderDefinition.class, "org.monet.metamodel.internal.TaskOrderDefinition", null);
            this.buildDependencyMap();
            this.prepareBuilders();
            this.initReplacers();
            this.createOntologiesMap();
            this.createSelfGeneratedThesaurusMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initReplacers() {
        for (Replacer replacer : this.replacersList) {
            try {
                Definition definition = this.getDefinition(replacer.Name);
                Definition replacedDefinition = this.getDefinition(replacer.ReplacedName);
                if (definition instanceof ContainerDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.containersMap);
                    continue;
                }
                if (definition instanceof DesktopDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.desktopsMap);
                    continue;
                }
                if (definition instanceof CollectionDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.collectionsMap);
                    continue;
                }
                if (definition instanceof FormDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.formsMap);
                    continue;
                }
                if (definition instanceof DocumentDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.documentsMap);
                    continue;
                }
                if (definition instanceof CatalogDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.catalogsMap);
                    continue;
                }
                if (definition instanceof TaskDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.taskMap, this.servicesMap);
                    this.replaceDefinition(definition, replacedDefinition, this.jobsMap);
                    continue;
                }
                if (definition instanceof IndexDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.indexMap);
                    continue;
                }
                if (definition instanceof ThesaurusDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.thesaurusMap);
                    this.replaceDefinition(definition, replacedDefinition, this.sourceMap);
                    continue;
                }
                if (definition instanceof GlossaryDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.glossaryMap);
                    this.replaceDefinition(definition, replacedDefinition, this.sourceMap);
                    continue;
                }
                if (definition instanceof KpiDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.kpiMap);
                    continue;
                }
                if (definition instanceof MeasureUnitDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.measureUnitMap);
                    continue;
                }
                if (definition instanceof DashboardDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.dashboardMap);
                    continue;
                }
                if (definition instanceof DatastoreDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.datastoreMap);
                    continue;
                }
                if (definition instanceof ImporterDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.importersMap);
                    continue;
                }
                if (definition instanceof ExporterDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.exportersMap);
                    continue;
                }
                if (definition instanceof RoleDefinition) {
                    this.replaceDefinition(definition, replacedDefinition, this.rolesMap);
                    continue;
                }
                if (!(definition instanceof DatastoreBuilderDefinition)) continue;
                this.replaceDefinition(definition, replacedDefinition, this.datastoreBuilderMap);
            }
            catch (Exception exception) {}
        }
    }

    private ArrayList<String> getOntologiesMap(NodeDefinition definition) {
        ArrayList<String> ontologies;
        block4: {
            block5: {
                block3: {
                    ontologies = new ArrayList<String>();
                    if (!(definition instanceof ContainerDefinition)) break block3;
                    ContainerDefinition containerDefinition = (ContainerDefinition)definition;
                    for (Ref containDefinition : containerDefinition.getContain().getNode()) {
                        ArrayList<String> childOntologies = this.getOntologiesMap(this.getNodeDefinition(containDefinition.getValue()));
                        ontologies.addAll(childOntologies);
                    }
                    break block4;
                }
                if (!(definition instanceof CollectionDefinition)) break block5;
                CollectionDefinition collectionDefinition = (CollectionDefinition)definition;
                for (Ref addDefinition : collectionDefinition.getAdd().getNode()) {
                    ArrayList<String> childOntologies = this.getOntologiesMap(this.getNodeDefinition(addDefinition.getValue()));
                    ontologies.addAll(childOntologies);
                }
                break block4;
            }
            if (!(definition instanceof FormDefinition)) break block4;
            FormDefinition formDefinition = (FormDefinition)definition;
            ArrayList<String> sourceList = formDefinition.getSources();
            for (String source : sourceList) {
                SourceDefinition sourceDefinition = this.getSourceDefinition(source);
                if (!(sourceDefinition instanceof GlossaryDefinition)) continue;
                ontologies.add(sourceDefinition.getOntology());
            }
        }
        return ontologies;
    }

    private void createOntologiesMap() {
        this.ontologiesMap.clear();
        for (NodeDefinition definition : this.nodesMap.values()) {
            if (!definition.requirePartnerContext()) continue;
            ArrayList<String> ontologies = this.getOntologiesMap(definition);
            this.ontologiesMap.put(definition.getName(), ontologies);
            this.ontologiesMap.put(definition.getCode(), ontologies);
        }
    }

    private void createSelfGeneratedThesaurusMap() {
        for (ThesaurusDefinition definition : this.thesaurusList) {
            if (!definition.isSelfGenerated()) continue;
            this.registerSelfGeneratedThesaurus(definition);
        }
    }

    private <T extends Definition> void replaceDefinition(Definition definition, Definition replacedDefinition, HashMap<String, T> ... maps) {
        String code = replacedDefinition.getCode().toLowerCase();
        String name = replacedDefinition.getName().toLowerCase();
        replacedDefinition.setIsAbstract(true);
        for (HashMap<String, T> map : maps) {
            map.put(name, definition);
            map.put(code, definition);
        }
        this.definitionMap.put(name, definition);
        this.definitionMap.put(code, definition);
    }

    private void buildDependencyMap() {
        for (String string : this.preDependencyMap.keySet()) {
            ArrayList<String> implementers = new ArrayList<String>();
            this.dependencyMap.put(string, implementers);
            Definition definition = this.definitionMap.get(string);
            if (definition != null && !definition.isAbstract()) {
                implementers.add(string);
                continue;
            }
            if (definition != null) continue;
            throw new RuntimeException(string);
        }
        for (Map.Entry entry : this.preDependencyMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.addImplementerTo((String)entry.getValue(), (String)entry.getKey());
        }
        this.preDependencyMap.clear();
    }

    private void addImplementerTo(String definitionName, String implementerName) {
        this.dependencyMap.get(definitionName).add(implementerName);
        String parent = this.preDependencyMap.get(definitionName);
        if (parent != null) {
            this.addImplementerTo(parent, implementerName);
        }
    }

    public void clean() {
        this.nodesMap.clear();
        this.containersMap.clear();
        this.containersList.clear();
        this.collectionsMap.clear();
        this.collectionsList.clear();
        this.desktopsMap.clear();
        this.desktopsList.clear();
        this.formsMap.clear();
        this.formsList.clear();
        this.documentsMap.clear();
        this.documentsList.clear();
        this.catalogsMap.clear();
        this.catalogsList.clear();
        this.servicesMap.clear();
        this.jobsMap.clear();
        this.taskMap.clear();
        this.taskList.clear();
        this.indexMap.clear();
        this.indexList.clear();
        this.sourceMap.clear();
        this.sourceList.clear();
        this.thesaurusMap.clear();
        this.thesaurusList.clear();
        this.glossaryMap.clear();
        this.glossaryList.clear();
        this.measureUnitMap.clear();
        this.measureUnitList.clear();
        this.dashboardMap.clear();
        this.dashboardList.clear();
        this.indicatorFormulaClassMap.clear();
        this.taxonomyClassifierClassMap.clear();
        this.datastoreMap.clear();
        this.datastoreList.clear();
        this.dimensionMap.clear();
        this.cubeMap.clear();
        this.importersList.clear();
        this.importersMap.clear();
        this.exportersMap.clear();
        this.definitionMap.clear();
        this.definitionList.clear();
        this.environments.clear();
        this.rolesMap.clear();
        this.rolesList.clear();
        this.rolesNames.clear();
        this.fieldsMap.clear();
        this.datastoreBuilders.clear();
        this.datastoreBuilderMap.clear();
        this.datastoreBuilderList.clear();
        this.layoutDefinitionMap.clear();
        this.kpiMap.clear();
        this.languages.clear();
        this.replacersList.clear();
        this.defaultLanguage = null;
    }

    public ArrayList<String> getOntologies(String definitionKey) {
        if (!this.ontologiesMap.containsKey(definitionKey)) {
            return null;
        }
        return this.ontologiesMap.get(definitionKey);
    }

    public String basePackage() {
        if (this.basePackage != null) {
            return this.basePackage;
        }
        for (Definition d : this.getAllDefinitions()) {
            if (d instanceof TaskOrderDefinition) continue;
            String name = d.getName();
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            if (this.basePackage == null) {
                this.basePackage = name;
                continue;
            }
            this.basePackage = StringUtil.greatestCommonPrefix(this.basePackage, name);
        }
        return this.basePackage;
    }
}

